/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.core.office;

import com.luues.openoffice.core.office.ExternalOfficeManager;
import com.luues.openoffice.core.office.OfficeConnectionProtocol;
import com.luues.openoffice.core.office.OfficeManager;
import com.luues.openoffice.core.office.UnoUrl;

public class ExternalOfficeManagerConfiguration {
    private OfficeConnectionProtocol connectionProtocol = OfficeConnectionProtocol.SOCKET;
    private int portNumber = 2002;
    private String pipeName = "office";
    private boolean connectOnStart = true;

    public ExternalOfficeManagerConfiguration setConnectionProtocol(OfficeConnectionProtocol connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public ExternalOfficeManagerConfiguration setPortNumber(int portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public ExternalOfficeManagerConfiguration setPipeName(String pipeName) {
        this.pipeName = pipeName;
        return this;
    }

    public ExternalOfficeManagerConfiguration setConnectOnStart(boolean connectOnStart) {
        this.connectOnStart = connectOnStart;
        return this;
    }

    public OfficeManager buildOfficeManager() {
        UnoUrl unoUrl = this.connectionProtocol == OfficeConnectionProtocol.SOCKET ? UnoUrl.socket(this.portNumber) : UnoUrl.pipe(this.pipeName);
        return new ExternalOfficeManager(unoUrl, this.connectOnStart);
    }
}

