/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.utils;

import com.luues.openoffice.core.OfficeDocumentConverter;
import com.luues.openoffice.core.office.DefaultOfficeManagerConfiguration;
import com.luues.openoffice.core.office.OfficeManager;
import com.luues.openoffice.core.office.OfficeUtils;
import com.luues.openoffice.extend.ControlDocumentFormatRegistry;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConverterUtils {
    OfficeManager officeManager;
    @Autowired
    private OfficeUtils officeUtils;

    @PostConstruct
    public void initOfficeManager() {
        if (null == this.officeUtils.getDefaultOfficeHome()) {
            return;
        }
        String officeHome = this.officeUtils.getDefaultOfficeHome().getAbsolutePath();
        DefaultOfficeManagerConfiguration configuration = new DefaultOfficeManagerConfiguration();
        configuration.setOfficeHome(officeHome);
        configuration.setPortNumber(8100);
        this.officeManager = configuration.buildOfficeManager();
        this.officeManager.start();
    }

    public OfficeDocumentConverter getDocumentConverter() {
        OfficeDocumentConverter converter = new OfficeDocumentConverter(this.officeManager, new ControlDocumentFormatRegistry());
        converter.setDefaultLoadProperties(this.getLoadProperties());
        return converter;
    }

    private Map<String, ?> getLoadProperties() {
        HashMap<String, Object> loadProperties = new HashMap<String, Object>(10);
        loadProperties.put("Hidden", true);
        loadProperties.put("ReadOnly", true);
        loadProperties.put("UpdateDocMode", (short)1);
        loadProperties.put("CharacterSet", Charset.forName("UTF-8").name());
        return loadProperties;
    }

    @PreDestroy
    public void destroyOfficeManager() {
        if (null != this.officeManager && this.officeManager.isRunning()) {
            this.officeManager.stop();
        }
    }
}

