/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.utils;

import com.luues.openoffice.utils.FileUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PdfUtils {
    private final Logger LOGGER = LoggerFactory.getLogger(PdfUtils.class);
    @Autowired
    FileUtils fileUtils;

    public List<String> pdf2jpg(String pdfFilePath, String pdfName, String url) {
        ArrayList<String> imageUrls = new ArrayList<String>();
        Integer imageCount = this.fileUtils.getConvertedPdfImage(pdfFilePath);
        String imageFileSuffix = ".jpg";
        int index1 = url.indexOf("/", 8);
        String pdfFolder = pdfName.substring(0, pdfName.length() - 4);
        String urlPrefix = url.substring(0, index1 + 1) + pdfFolder;
        if (imageCount != null && imageCount > 0) {
            for (int i = 0; i < imageCount; ++i) {
                imageUrls.add(urlPrefix + "/" + i + imageFileSuffix);
            }
            return imageUrls;
        }
        try {
            File pdfFile = new File(pdfFilePath);
            PDDocument doc = PDDocument.load((File)pdfFile);
            int pageCount = doc.getNumberOfPages();
            PDFRenderer pdfRenderer = new PDFRenderer(doc);
            int index = pdfFilePath.lastIndexOf(".");
            String folder = pdfFilePath.substring(0, index);
            File path = new File(folder);
            if (!path.exists()) {
                path.mkdirs();
            }
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                String imageFilePath = folder + File.separator + pageIndex + imageFileSuffix;
                BufferedImage image = pdfRenderer.renderImageWithDPI(pageIndex, 105.0f, ImageType.RGB);
                ImageIOUtil.writeImage((BufferedImage)image, (String)imageFilePath, (int)105);
                imageUrls.add(urlPrefix + "/" + pageIndex + imageFileSuffix);
            }
            doc.close();
            this.fileUtils.addConvertedPdfImage(pdfFilePath, pageCount);
        }
        catch (IOException e) {
            this.LOGGER.error("Convert pdf to jpg exception", (Throwable)e);
        }
        return imageUrls;
    }
}

