package com.luues.mail;

import com.luues.util.freemarker.FreemarkerUtil;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.*;
import javax.mail.internet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * 发送邮件工具类
 * @author Mr-Wu
 * @param
 * SendMsg sendMsg = new SendMsg("service@wqzhu.com", "Wqzhusystem2015", "25", "smtp.exmail.qq.com", "测试发送邮件");
 * sendMsg.sendTextEmail("ceshi", "test", "709064797@qq.com");
 * Map<String, Object> dataMap = new HashMap<String, Object>();
 * dataMap.put("code", "999");
 * sendMsg.sendFtlEmail(request, "ftl测试", dataMap, new File(this.getClass().getResource("/ftl/test.ftl").getPath()), "709064797@qq.com");
 */
public class SendMsg extends Authenticator {

    private SendMsg sendMsg;
    private String userName; //邮箱账号
    private String password; //邮箱密码
    private String port; //端口
    private String host;
    private String fromName;
    private boolean debug;

    public SendMsg(String userName, String password, String port, String host, boolean debug, String fromName) {
        this.userName = userName;
        this.password = password;
        this.port = port;
        this.host = host;
        this.debug = debug;
        this.fromName = fromName;
    }

    public SendMsg(String userName, String password, String port, String host,String fromName) {
        this.userName = userName;
        this.password = password;
        this.port = port;
        this.host = host;
        this.fromName = fromName;
    }

    private SendMsg() {
    }

    protected SendMsg(String username, String password) {
        this.userName = username;
        this.password = password;
    }


    public boolean sendTextEmail(String title, String content, String... receiveEmail) throws MessagingException {
        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setDebug(debug);
        mailInfo.setValidate(true);
        mailInfo.setMailServerHost(host);
        mailInfo.setMailServerPort(port);
        mailInfo.setUserName(userName);
        mailInfo.setPassword(password);
        mailInfo.setFromName(fromName);
        mailInfo.setFromAddress(userName);
        for (String mail : receiveEmail) {
            mailInfo.setToAddress(mail);
            mailInfo.setSubject(title);
            mailInfo.setContent(content);
            sendMail(mailInfo);
        }
        return true;
    }

    public boolean sendFtlEmail(HttpServletRequest request, String title, Map<String, Object> dataMap, File ftl, String... receiveEmail) throws MessagingException {
        String content = getFTLHTMLContent(request, ftl, dataMap);
        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setDebug(debug);
        mailInfo.setValidate(true);
        mailInfo.setMailServerHost(host);
        mailInfo.setMailServerPort(port);
        mailInfo.setUserName(userName);
        mailInfo.setPassword(password);
        mailInfo.setFromName(fromName);
        mailInfo.setFromAddress(userName);
        for (String mail : receiveEmail) {
            mailInfo.setToAddress(mail);
            mailInfo.setSubject(title);
            Multipart mainPart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            try {
                messageBodyPart.setContent(content, "text/html; charset=utf-8");
            } catch (MessagingException e1) {
                e1.printStackTrace();
            }
            try {
                mainPart.addBodyPart(messageBodyPart);
            } catch (MessagingException e1) {
                e1.printStackTrace();
            }
            mailInfo.setContent(mainPart);
            sendMail(mailInfo);
        }
        return true;
    }

    public boolean sendFtlEmailByImageFile(String outPath, String filePath, String fileName, String title, Map<String, Object> dataMap, File ftl, String... receiveEmail) throws MessagingException {
        String content = getFTLHTMLContent(outPath, ftl, dataMap);
        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setDebug(debug);
        mailInfo.setValidate(true);
        mailInfo.setMailServerHost(host);
        mailInfo.setMailServerPort(port);
        mailInfo.setUserName(userName);
        mailInfo.setPassword(password);
        mailInfo.setFromName(fromName);
        mailInfo.setFromAddress(userName);
        for (String mail : receiveEmail) {
            mailInfo.setToAddress(mail);
            mailInfo.setSubject(title);
            Multipart mainPart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent(content, "text/html; charset=utf-8");
            mainPart.addBodyPart(messageBodyPart);
            // 附件部分
            messageBodyPart = new MimeBodyPart();
            // 设置要发送附件的文件路径
            DataSource source = new FileDataSource(filePath);
            messageBodyPart.setDataHandler(new DataHandler(source));
            // messageBodyPart.setFileName(filename);
            // 处理附件名称中文（附带文件路径）乱码问题
            try {
                messageBodyPart.setFileName(MimeUtility.encodeText(fileName));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            mainPart.addBodyPart(messageBodyPart);
            mailInfo.setContent(mainPart);
            sendMail(mailInfo);
        }
        return true;
    }


    protected PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.userName, this.password);
    }

    protected static Map<String, Object> getDataMap() {
        Map<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("baseName", "");
        return dataMap;
    }

    /**
     * @param file      ftl文件上级目录
     * @param dataMap   数据
     * @return
     */
    protected String getFTLHTMLContent(HttpServletRequest request, File file, Map<String, Object> dataMap) {
        FreemarkerUtil freemarkerUtil = new FreemarkerUtil();
        String fileName_ = freemarkerUtil.getTemplateContent(request, file, dataMap);
        StringBuffer data = new StringBuffer();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName_);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        InputStreamReader Inputreader = null;
        try {
            Inputreader = new InputStreamReader(fis, "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        BufferedReader br = new BufferedReader(Inputreader);
        String temp = null;
        try {
            temp = br.readLine();
            while (temp != null) {
                data.append(temp).append("\n");
                try {
                    temp = br.readLine();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (fis != null)
                    fis.close();
                if (Inputreader != null)
                    Inputreader.close();
                if (br != null)
                    br.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        File dfile = new File(fileName_);
        if (!dfile.exists()) {
        } else {
            dfile.delete();
        }
        return data.toString();
    }

    /**
     * @param file      ftl文件上级目录
     * @param dataMap   数据
     * @return
     */
    protected String getFTLHTMLContent(String outPath, File file, Map<String, Object> dataMap) {
        FreemarkerUtil freemarkerUtil = new FreemarkerUtil();
        String fileName_ = freemarkerUtil.getTemplateContent(outPath, file, dataMap);
        StringBuffer data = new StringBuffer();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName_);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        InputStreamReader Inputreader = null;
        try {
            Inputreader = new InputStreamReader(fis, "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        BufferedReader br = new BufferedReader(Inputreader);
        String temp = null;
        try {
            temp = br.readLine();
            while (temp != null) {
                data.append(temp).append("\n");
                try {
                    temp = br.readLine();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (fis != null)
                    fis.close();
                if (Inputreader != null)
                    Inputreader.close();
                if (br != null)
                    br.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        File dfile = new File(fileName_);
        if (!dfile.exists()) {
        } else {
            dfile.delete();
        }
        return data.toString();
    }

    protected boolean sendMail(MailSenderInfo mailInfo) throws MessagingException {
        SendMsg authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new SendMsg(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getInstance(pro, authenticator);
        Message mailMessage = new MimeMessage(sendMailSession);
        Address from = null;
        try {
            from = new InternetAddress(mailInfo.getFromAddress(), mailInfo.getFromName(), "UTF-8");
        } catch (UnsupportedEncodingException e) {
        }
        mailMessage.setFrom(from);
        Address to = new InternetAddress(mailInfo.getToAddress());
        mailMessage.setRecipient(Message.RecipientType.TO, to);
        mailMessage.setSubject(mailInfo.getSubject());
        mailMessage.setSentDate(new Date());
        Multipart mainPart = new MimeMultipart();
        BodyPart html = new MimeBodyPart();
        html.setContent(mailInfo.getContent(), "text/html; charset=utf-8");
        mainPart.addBodyPart(html);
        mailMessage.setContent(mainPart);
        try {
            Transport.send(mailMessage);
        } catch (Exception e) {
            return false;
        }
        return true;
    }
}