/*
 * Decompiled with CFR 0.152.
 */
package com.luues.mail;

import com.luues.mail.MailSenderInfo;
import com.luues.util.freemarker.FreemarkerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;

public class SendMsg
extends Authenticator {
    private SendMsg sendMsg;
    private String userName;
    private String password;
    private String port;
    private String host;
    private String fromName;
    private boolean debug;

    public SendMsg(String userName, String password, String port, String host, boolean debug, String fromName) {
        this.userName = userName;
        this.password = password;
        this.port = port;
        this.host = host;
        this.debug = debug;
        this.fromName = fromName;
    }

    public SendMsg(String userName, String password, String port, String host, String fromName) {
        this.userName = userName;
        this.password = password;
        this.port = port;
        this.host = host;
        this.fromName = fromName;
    }

    private SendMsg() {
    }

    protected SendMsg(String username, String password) {
        this.userName = username;
        this.password = password;
    }

    public boolean sendTextEmail(String title, String content, String ... receiveEmail) throws MessagingException {
        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setDebug(this.debug);
        mailInfo.setValidate(true);
        mailInfo.setMailServerHost(this.host);
        mailInfo.setMailServerPort(this.port);
        mailInfo.setUserName(this.userName);
        mailInfo.setPassword(this.password);
        mailInfo.setFromName(this.fromName);
        mailInfo.setFromAddress(this.userName);
        for (String mail : receiveEmail) {
            mailInfo.setToAddress(mail);
            mailInfo.setSubject(title);
            mailInfo.setContent(content);
            this.sendMail(mailInfo);
        }
        return true;
    }

    public boolean sendFtlEmail(HttpServletRequest request, String title, Map<String, Object> dataMap, File ftl, String ... receiveEmail) throws MessagingException {
        String content = this.getFTLHTMLContent(request, ftl, dataMap);
        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setDebug(this.debug);
        mailInfo.setValidate(true);
        mailInfo.setMailServerHost(this.host);
        mailInfo.setMailServerPort(this.port);
        mailInfo.setUserName(this.userName);
        mailInfo.setPassword(this.password);
        mailInfo.setFromName(this.fromName);
        mailInfo.setFromAddress(this.userName);
        for (String mail : receiveEmail) {
            mailInfo.setToAddress(mail);
            mailInfo.setSubject(title);
            MimeMultipart mainPart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            try {
                messageBodyPart.setContent((Object)content, "text/html; charset=utf-8");
            }
            catch (MessagingException e1) {
                e1.printStackTrace();
            }
            try {
                mainPart.addBodyPart((BodyPart)messageBodyPart);
            }
            catch (MessagingException e1) {
                e1.printStackTrace();
            }
            mailInfo.setContent(mainPart);
            this.sendMail(mailInfo);
        }
        return true;
    }

    public boolean sendFtlEmailByImageFile(String outPath, String filePath, String fileName, String title, Map<String, Object> dataMap, File ftl, String ... receiveEmail) throws MessagingException {
        String content = this.getFTLHTMLContent(outPath, ftl, dataMap);
        MailSenderInfo mailInfo = new MailSenderInfo();
        mailInfo.setDebug(this.debug);
        mailInfo.setValidate(true);
        mailInfo.setMailServerHost(this.host);
        mailInfo.setMailServerPort(this.port);
        mailInfo.setUserName(this.userName);
        mailInfo.setPassword(this.password);
        mailInfo.setFromName(this.fromName);
        mailInfo.setFromAddress(this.userName);
        for (String mail : receiveEmail) {
            mailInfo.setToAddress(mail);
            mailInfo.setSubject(title);
            MimeMultipart mainPart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)content, "text/html; charset=utf-8");
            mainPart.addBodyPart((BodyPart)messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(filePath);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            try {
                messageBodyPart.setFileName(MimeUtility.encodeText((String)fileName));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            mainPart.addBodyPart((BodyPart)messageBodyPart);
            mailInfo.setContent(mainPart);
            this.sendMail(mailInfo);
        }
        return true;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.userName, this.password);
    }

    protected static Map<String, Object> getDataMap() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("baseName", "");
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFTLHTMLContent(HttpServletRequest request, File file, Map<String, Object> dataMap) {
        FreemarkerUtil freemarkerUtil = new FreemarkerUtil();
        String fileName_ = freemarkerUtil.getTemplateContent(request, file, dataMap);
        StringBuffer data = new StringBuffer();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName_);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        InputStreamReader Inputreader = null;
        try {
            Inputreader = new InputStreamReader((InputStream)fis, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        BufferedReader br = new BufferedReader(Inputreader);
        String temp = null;
        try {
            temp = br.readLine();
            while (temp != null) {
                data.append(temp).append("\n");
                try {
                    temp = br.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (Inputreader != null) {
                    Inputreader.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File dfile = new File(fileName_);
        if (dfile.exists()) {
            dfile.delete();
        }
        return data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFTLHTMLContent(String outPath, File file, Map<String, Object> dataMap) {
        FreemarkerUtil freemarkerUtil = new FreemarkerUtil();
        String fileName_ = freemarkerUtil.getTemplateContent(outPath, file, dataMap);
        StringBuffer data = new StringBuffer();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName_);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        InputStreamReader Inputreader = null;
        try {
            Inputreader = new InputStreamReader((InputStream)fis, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        BufferedReader br = new BufferedReader(Inputreader);
        String temp = null;
        try {
            temp = br.readLine();
            while (temp != null) {
                data.append(temp).append("\n");
                try {
                    temp = br.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (Inputreader != null) {
                    Inputreader.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File dfile = new File(fileName_);
        if (dfile.exists()) {
            dfile.delete();
        }
        return data.toString();
    }

    protected boolean sendMail(MailSenderInfo mailInfo) throws MessagingException {
        SendMsg authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new SendMsg(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getInstance((Properties)pro, authenticator);
        MimeMessage mailMessage = new MimeMessage(sendMailSession);
        InternetAddress from = null;
        try {
            from = new InternetAddress(mailInfo.getFromAddress(), mailInfo.getFromName(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        mailMessage.setFrom(from);
        InternetAddress to = new InternetAddress(mailInfo.getToAddress());
        mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
        mailMessage.setSubject(mailInfo.getSubject());
        mailMessage.setSentDate(new Date());
        MimeMultipart mainPart = new MimeMultipart();
        MimeBodyPart html = new MimeBodyPart();
        html.setContent(mailInfo.getContent(), "text/html; charset=utf-8");
        mainPart.addBodyPart((BodyPart)html);
        mailMessage.setContent((Multipart)mainPart);
        try {
            Transport.send((Message)mailMessage);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

