/*
 * Decompiled with CFR 0.152.
 */
package cn.luues.tool.http.server.action;

import cn.luues.tool.core.collection.CollUtil;
import cn.luues.tool.core.io.FileUtil;
import cn.luues.tool.core.lang.Console;
import cn.luues.tool.http.server.HttpServerRequest;
import cn.luues.tool.http.server.HttpServerResponse;
import cn.luues.tool.http.server.action.Action;
import java.io.File;
import java.util.List;

public class RootAction
implements Action {
    public static final String DEFAULT_INDEX_FILE_NAME = "index.html";
    private final File rootDir;
    private final List<String> indexFileNames;

    public RootAction(String rootDir) {
        this(new File(rootDir));
    }

    public RootAction(File rootDir) {
        this(rootDir, DEFAULT_INDEX_FILE_NAME);
    }

    public RootAction(String rootDir, String ... indexFileNames) {
        this(new File(rootDir), indexFileNames);
    }

    public RootAction(File rootDir, String ... indexFileNames) {
        this.rootDir = rootDir;
        this.indexFileNames = CollUtil.toList((Object[])indexFileNames);
    }

    @Override
    public void doAction(HttpServerRequest request, HttpServerResponse response) {
        String path = request.getPath();
        File file = FileUtil.file((File)this.rootDir, (String)path);
        if (file.exists()) {
            if (file.isDirectory()) {
                for (String indexFileName : this.indexFileNames) {
                    if (!(file = FileUtil.file((File)file, (String)indexFileName)).exists() || !file.isFile()) continue;
                    response.write(file);
                }
            } else {
                response.write(file);
            }
        }
        Console.log((Object)file.getAbsolutePath());
        response.send404("404 Not Found !");
    }
}

