/*
 * Decompiled with CFR 0.152.
 */
package cn.luues.tool.http.ssl;

import cn.luues.tool.core.net.SSLContextBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLSocketFactoryBuilder {
    public static final String SSL = "SSL";
    public static final String SSLv2 = "SSLv2";
    public static final String SSLv3 = "SSLv3";
    public static final String TLS = "TLS";
    public static final String TLSv1 = "TLSv1";
    public static final String TLSv11 = "TLSv1.1";
    public static final String TLSv12 = "TLSv1.2";
    SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();

    public static SSLSocketFactoryBuilder create() {
        return new SSLSocketFactoryBuilder();
    }

    public static SSLSocketFactoryBuilder createTLS(FileInputStream fileInputStream, char[] password) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(fileInputStream, password);
        fileInputStream.close();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        return new SSLSocketFactoryBuilder().setKeyManagers(keyManagerFactory.getKeyManagers()).setTrustManagers(null).setSecureRandom(new SecureRandom());
    }

    public static SSLSocketFactoryBuilder createTLS() {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        return new SSLSocketFactoryBuilder().setKeyManagers(null).setTrustManagers(trustManager).setSecureRandom(null);
    }

    public static SSLSocketFactoryBuilder createdTLS() {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        return new SSLSocketFactoryBuilder().setProtocol(SSL).setKeyManagers(null).setTrustManagers(trustManager).setSecureRandom(null);
    }

    public SSLSocketFactoryBuilder setProtocol(String protocol) {
        this.sslContextBuilder.setProtocol(protocol);
        return this;
    }

    public SSLSocketFactoryBuilder setTrustManagers(TrustManager ... trustManagers) {
        this.sslContextBuilder.setTrustManagers(trustManagers);
        return this;
    }

    public SSLSocketFactoryBuilder setKeyManagers(KeyManager ... keyManagers) {
        this.sslContextBuilder.setKeyManagers(keyManagers);
        return this;
    }

    public SSLSocketFactoryBuilder setSecureRandom(SecureRandom secureRandom) {
        this.sslContextBuilder.setSecureRandom(secureRandom);
        return this;
    }

    public SSLSocketFactory build() throws NoSuchAlgorithmException, KeyManagementException {
        return this.sslContextBuilder.build().getSocketFactory();
    }
}

