package cn.luues.tool.log;

import lombok.extern.slf4j.Slf4j;

/**
 * 静态日志类，用于在不引入日志对象的情况下打印日志
 * 
 * @author Mr-Wu
 *
 */
@Slf4j(topic = "c.l.t.l.Log")
public class Log {

	private Log() {
	}

	public static boolean isInfoEnabled(){
		return log.isInfoEnabled();
	}

	public static boolean isDebugEnabled(){
		return log.isDebugEnabled();
	}

	public static boolean isErrorEnabled(){
		return log.isErrorEnabled();
	}

	public static boolean isTraceEnabled(){
		return log.isTraceEnabled();
	}

	public static boolean isWarnEnabled(){
		return log.isWarnEnabled();
	}

	// ----------------------------------------------------------- Log method start
	// ------------------------ Trace
	public static void trace(String msg) {
		log.trace(msg);
	}
	/**
	 * Trace等级日志，小于debug<br>
	 * 由于动态获取Log，效率较低，建议在非频繁调用的情况下使用！！
	 * 
	 * @param format 格式文本，{} 代表变量
	 * @param arguments 变量对应的参数
	 */
	public static void trace(String format, Object... arguments) {
		log.trace(format, arguments);
	}

	// ------------------------ debug
	public static void debug(String msg) {
		log.debug(msg);
	}
	/**
	 * Debug等级日志，小于Info<br>
	 * 由于动态获取Log，效率较低，建议在非频繁调用的情况下使用！！
	 * 
	 * @param format 格式文本，{} 代表变量
	 * @param arguments 变量对应的参数
	 */
	public static void debug(String format, Object... arguments) {
		log.debug(format, arguments);
	}

	// ------------------------ info
	public static void info(String msg) {
		log.info(msg);
	}
	/**
	 * Info等级日志，小于Warn<br>
	 * 由于动态获取Log，效率较低，建议在非频繁调用的情况下使用！！
	 * 
	 * @param format 格式文本，{} 代表变量
	 * @param arguments 变量对应的参数
	 */
	public static void info(String format, Object... arguments) {
		log.info(format, arguments);
	}

	// ------------------------ warn
	public static void warn(String msg) {
		log.warn(msg);
	}
	/**
	 * Warn等级日志，小于Error<br>
	 * 由于动态获取Log，效率较低，建议在非频繁调用的情况下使用！！
	 * 
	 * @param format 格式文本，{} 代表变量
	 * @param arguments 变量对应的参数
	 */
	public static void warn(String format, Object... arguments) {
		log.warn(format, arguments);
	}

	// ------------------------ error
	public static void error(String msg) {
		log.error(msg);
	}
	/**
	 * Error等级日志<br>
	 * 由于动态获取Log，效率较低，建议在非频繁调用的情况下使用！！
	 * 
	 * @param format 格式文本，{} 代表变量
	 * @param arguments 变量对应的参数
	 */
	public static void error(String format, Object... arguments) {
		log.error(format, arguments);
	}

	// ----------------------------------------------------------- Log method end

	public static synchronized void debug(String[] strings){
		for(String string : strings)
			debug(string);
	}
	public static synchronized void info(String[] strings){
		for(String string : strings)
			info(string);
	}
	public static synchronized void error(String[] strings){
		for(String string : strings)
			error(string);
	}
	public static synchronized void warn(String[] strings){
		for(String string : strings)
			warn(string);
	}

}
