/*
 * Decompiled with CFR 0.152.
 */
package com.github.abara.library.batterystats;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import java.text.DecimalFormat;
import java.util.Calendar;

public class BatteryStats {
    public static final int LIVE_TIME_MORNING = 0;
    public static final int LIVE_TIME_AFTERNOON = 1;
    public static final int LIVE_TIME_EVENING = 2;
    public static final int LIVE_TIME_NIGHT = 3;
    public static final int PLUGGED_STATE_AC = 0;
    public static final int PLUGGED_STATE_USB = 1;
    public static final int PLUGGED_STATE_WIRELESS = 2;
    public static final int PLUGGED_STATE_UNKNOWN = 3;
    public static final String DEGREE = "\u00b0";
    public static final int BATTERY_HEALTH_COLD = 0;
    public static final int BATTERY_HEALTH_DEAD = 1;
    public static final int BATTERY_HEALTH_GOOD = 2;
    public static final int BATTERY_HEALTH_OVER_VOLTAGE = 3;
    public static final int BATTERY_HEALTH_OVERHEAT = 4;
    public static final int BATTERY_HEALTH_UNKNOWN = 5;
    public static final int BATTERY_STATUS_FAILURE = -1;
    private Intent batteryIntent;

    private BatteryStats() {
    }

    public BatteryStats(Intent batteryIntent) {
        this.batteryIntent = batteryIntent;
    }

    public BatteryStats(Context context) {
        this.batteryIntent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
    }

    public Intent getBatteryIntent() {
        return this.batteryIntent;
    }

    public int getLiveTime() {
        Calendar calendar = Calendar.getInstance();
        int timeOfDay = calendar.get(11);
        if (timeOfDay >= 0 && timeOfDay < 12) {
            return 0;
        }
        if (timeOfDay >= 12 && timeOfDay < 16) {
            return 1;
        }
        if (timeOfDay >= 16 && timeOfDay < 21) {
            return 2;
        }
        if (timeOfDay >= 21 && timeOfDay < 24) {
            return 3;
        }
        return -1;
    }

    public int getLevel() {
        return this.batteryIntent.getIntExtra("level", 0);
    }

    public float getLevelAccurate() {
        int level = this.getLevel();
        int scale = this.getScale();
        return (float)level / (float)scale;
    }

    public int getScale() {
        return this.batteryIntent.getIntExtra("scale", -1);
    }

    public String getBatteryTechnology() {
        return this.batteryIntent.getStringExtra("technology");
    }

    public int getPluggedState() {
        int plug = this.batteryIntent.getIntExtra("plugged", -1);
        if (plug == 1) {
            return 0;
        }
        if (plug == 2) {
            return 1;
        }
        if (plug == 4) {
            return 2;
        }
        return 3;
    }

    public boolean isCharging() {
        int plugState = this.batteryIntent.getIntExtra("plugged", -1);
        return plugState == 1 || plugState == 2 || plugState == 4;
    }

    public int getHealth() {
        int health = this.batteryIntent.getIntExtra("health", -1);
        if (health == 7) {
            return 0;
        }
        if (health == 4) {
            return 1;
        }
        if (health == 2) {
            return 2;
        }
        if (health == 5) {
            return 3;
        }
        if (health == 3) {
            return 4;
        }
        if (health == 1) {
            return 5;
        }
        return -1;
    }

    public String getHealthText() {
        int health = this.getHealth();
        if (health == 0) {
            return "Cold";
        }
        if (health == 1) {
            return "Dead";
        }
        if (health == 2) {
            return "Good";
        }
        if (health == 3) {
            return "Bad";
        }
        if (health == 4) {
            return "Hot";
        }
        if (health == 5) {
            return "N/A";
        }
        return "FAIL";
    }

    public double getTemperature(boolean fahrenheit) {
        double celsius = this.batteryIntent.getIntExtra("temperature", 0) / 10;
        if (fahrenheit) {
            return celsius * 1.8 + 32.0;
        }
        return celsius;
    }

    public String getTemperatureText(boolean fahrenheit) {
        return String.valueOf(this.getTemperature(fahrenheit)) + DEGREE + "C";
    }

    public double getVoltage() {
        double volt = this.batteryIntent.getIntExtra("voltage", 0);
        return Double.valueOf(new DecimalFormat("#.##").format(volt / 1000.0));
    }

    public double getVoltage(String pattern) {
        double volt = this.getVoltage();
        return Double.valueOf(new DecimalFormat(pattern).format(volt / 1000.0));
    }
}

