/*
 * Decompiled with CFR 0.152.
 */
package com.github.abara.library.batterystats.service;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.github.abara.library.batterystats.BatteryStats;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public abstract class BatteryTimeService
extends Service {
    private ArrayList<Long> batteryDischargingTimes;
    private ArrayList<Long> batteryChargingTimes;
    private BroadcastReceiver levelReceiver = new BroadcastReceiver(){
        int oldDischargeLevel = 101;
        int oldChargeLevel = 0;
        long oldDischargeTime = 0L;
        long oldChargeTime = 0L;

        public void onReceive(Context context, Intent intent) {
            long diffTime;
            long time;
            BatteryStats batteryStats = new BatteryStats(intent);
            boolean charging = batteryStats.isCharging();
            int level = batteryStats.getLevel();
            if (!charging && level <= 100) {
                if (level < this.oldDischargeLevel) {
                    time = System.currentTimeMillis();
                    if (this.oldDischargeTime != 0L) {
                        diffTime = time - this.oldDischargeTime;
                        BatteryTimeService.this.batteryDischargingTimes.add(diffTime);
                        BatteryTimeService.this.publishDischargingText(level);
                    } else {
                        BatteryTimeService.this.onCalculatingDischargingTime();
                    }
                    this.oldDischargeTime = time;
                    this.oldDischargeLevel = level;
                }
                BatteryTimeService.this.batteryChargingTimes.clear();
                this.oldChargeLevel = 0;
                this.oldChargeTime = 0L;
            }
            if (charging) {
                if (this.oldChargeLevel < level) {
                    time = System.currentTimeMillis();
                    if (this.oldChargeTime != 0L) {
                        diffTime = time - this.oldChargeTime;
                        BatteryTimeService.this.batteryChargingTimes.add(diffTime);
                        BatteryTimeService.this.publishChargingText(level);
                    } else {
                        BatteryTimeService.this.onCalculatingChargingTime();
                    }
                    this.oldChargeTime = time;
                    this.oldChargeLevel = level;
                }
                if (level == 100) {
                    BatteryTimeService.this.onFullBattery();
                }
                BatteryTimeService.this.batteryDischargingTimes.clear();
                this.oldDischargeLevel = 100;
                this.oldDischargeTime = 0L;
            }
        }
    };

    protected abstract void onChargingTimePublish(int var1, int var2);

    protected abstract void onCalculatingChargingTime();

    protected abstract void onDischargeTimePublish(int var1, int var2, int var3);

    protected abstract void onCalculatingDischargingTime();

    protected abstract void onFullBattery();

    public void onCreate() {
        super.onCreate();
        this.batteryDischargingTimes = new ArrayList();
        this.batteryChargingTimes = new ArrayList();
        this.registerReceiver(this.levelReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
    }

    private void publishChargingText(int level) {
        long sum = 0L;
        for (Long time : this.batteryChargingTimes) {
            sum += time.longValue();
        }
        long average = sum / (long)this.batteryChargingTimes.size() * (long)(100 - level);
        int hours = (int)(TimeUnit.MILLISECONDS.toHours(average) % TimeUnit.DAYS.toHours(1L));
        int mins = (int)(TimeUnit.MILLISECONDS.toMinutes(average) % TimeUnit.HOURS.toMinutes(1L));
        this.onChargingTimePublish(hours, mins);
    }

    private void publishDischargingText(int level) {
        long sum = 0L;
        for (Long time : this.batteryDischargingTimes) {
            sum += time.longValue();
        }
        long average = sum / (long)this.batteryDischargingTimes.size() * (long)level;
        int days = (int)TimeUnit.MILLISECONDS.toDays(average);
        int hours = (int)(TimeUnit.MILLISECONDS.toHours(average) % TimeUnit.DAYS.toHours(1L));
        int mins = (int)(TimeUnit.MILLISECONDS.toMinutes(average) % TimeUnit.HOURS.toMinutes(1L));
        this.onDischargeTimePublish(days, hours, mins);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.levelReceiver);
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }
}

