/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.circleprogress;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.github.lzyzsd.circleprogress.R;
import com.github.lzyzsd.circleprogress.Utils;

public class DonutProgress
extends View {
    private Paint finishedPaint;
    private Paint unfinishedPaint;
    private Paint innerCirclePaint;
    protected Paint textPaint;
    private RectF finishedOuterRect = new RectF();
    private RectF unfinishedOuterRect = new RectF();
    private float textSize;
    private int textColor;
    private int progress = 0;
    private int max;
    private int finishedStrokeColor;
    private int unfinishedStrokeColor;
    private float finishedStrokeWidth;
    private float unfinishedStrokeWidth;
    private int innerBackgroundColor;
    private String prefixText = "";
    private String suffixText = "%";
    private final float default_stroke_width;
    private final int default_finished_color = Color.rgb((int)66, (int)145, (int)241);
    private final int default_unfinished_color = Color.rgb((int)204, (int)204, (int)204);
    private final int default_text_color = Color.rgb((int)66, (int)145, (int)241);
    private final int default_inner_background_color = 0;
    private final int default_max = 100;
    private final float default_text_size = Utils.sp2px(this.getResources(), 18.0f);
    private final int min_size = (int)Utils.dp2px(this.getResources(), 100.0f);
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String INSTANCE_TEXT_COLOR = "text_color";
    private static final String INSTANCE_TEXT_SIZE = "text_size";
    private static final String INSTANCE_FINISHED_STROKE_COLOR = "finished_stroke_color";
    private static final String INSTANCE_UNFINISHED_STROKE_COLOR = "unfinished_stroke_color";
    private static final String INSTANCE_MAX = "max";
    private static final String INSTANCE_PROGRESS = "progress";
    private static final String INSTANCE_SUFFIX = "suffix";
    private static final String INSTANCE_PREFIX = "prefix";
    private static final String INSTANCE_FINISHED_STROKE_WIDTH = "finished_stroke_width";
    private static final String INSTANCE_UNFINISHED_STROKE_WIDTH = "unfinished_stroke_width";
    private static final String INSTANCE_BACKGROUND_COLOR = "inner_background_color";

    public DonutProgress(Context context) {
        this(context, null);
    }

    public DonutProgress(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DonutProgress(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.default_stroke_width = Utils.dp2px(this.getResources(), 10.0f);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DonutProgress, defStyleAttr, 0);
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPainters();
    }

    protected void initPainters() {
        this.textPaint = new TextPaint();
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setAntiAlias(true);
        this.finishedPaint = new Paint();
        this.finishedPaint.setColor(this.finishedStrokeColor);
        this.finishedPaint.setStyle(Paint.Style.STROKE);
        this.finishedPaint.setAntiAlias(true);
        this.finishedPaint.setStrokeWidth(this.finishedStrokeWidth);
        this.unfinishedPaint = new Paint();
        this.unfinishedPaint.setColor(this.unfinishedStrokeColor);
        this.unfinishedPaint.setStyle(Paint.Style.STROKE);
        this.unfinishedPaint.setAntiAlias(true);
        this.unfinishedPaint.setStrokeWidth(this.unfinishedStrokeWidth);
        this.innerCirclePaint = new Paint();
        this.innerCirclePaint.setColor(this.innerBackgroundColor);
        this.innerCirclePaint.setAntiAlias(true);
    }

    protected void initByAttributes(TypedArray attributes) {
        this.finishedStrokeColor = attributes.getColor(3, this.default_finished_color);
        this.unfinishedStrokeColor = attributes.getColor(2, this.default_unfinished_color);
        this.textColor = attributes.getColor(7, this.default_text_color);
        this.textSize = attributes.getDimension(6, this.default_text_size);
        this.setMax(attributes.getInt(1, 100));
        this.setProgress(attributes.getInt(0, 0));
        this.finishedStrokeWidth = attributes.getDimension(4, this.default_stroke_width);
        this.unfinishedStrokeWidth = attributes.getDimension(5, this.default_stroke_width);
        if (attributes.getString(8) != null) {
            this.prefixText = attributes.getString(8);
        }
        if (attributes.getString(9) != null) {
            this.suffixText = attributes.getString(9);
        }
        this.innerBackgroundColor = attributes.getColor(10, 0);
    }

    public void invalidate() {
        this.initPainters();
        super.invalidate();
    }

    public float getFinishedStrokeWidth() {
        return this.finishedStrokeWidth;
    }

    public void setFinishedStrokeWidth(float finishedStrokeWidth) {
        this.finishedStrokeWidth = finishedStrokeWidth;
        this.invalidate();
    }

    public float getUnfinishedStrokeWidth() {
        return this.unfinishedStrokeWidth;
    }

    public void setUnfinishedStrokeWidth(float unfinishedStrokeWidth) {
        this.unfinishedStrokeWidth = unfinishedStrokeWidth;
        this.invalidate();
    }

    private float getProgressAngle() {
        return (float)this.getProgress() / (float)this.max * 360.0f;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        if (this.progress > this.getMax()) {
            this.progress %= this.getMax();
        }
        this.invalidate();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        if (max > 0) {
            this.max = max;
            this.invalidate();
        }
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public int getFinishedStrokeColor() {
        return this.finishedStrokeColor;
    }

    public void setFinishedStrokeColor(int finishedStrokeColor) {
        this.finishedStrokeColor = finishedStrokeColor;
        this.invalidate();
    }

    public int getUnfinishedStrokeColor() {
        return this.unfinishedStrokeColor;
    }

    public void setUnfinishedStrokeColor(int unfinishedStrokeColor) {
        this.unfinishedStrokeColor = unfinishedStrokeColor;
        this.invalidate();
    }

    public String getSuffixText() {
        return this.suffixText;
    }

    public void setSuffixText(String suffixText) {
        this.suffixText = suffixText;
        this.invalidate();
    }

    public String getPrefixText() {
        return this.prefixText;
    }

    public void setPrefixText(String prefixText) {
        this.prefixText = prefixText;
        this.invalidate();
    }

    public int getInnerBackgroundColor() {
        return this.innerBackgroundColor;
    }

    public void setInnerBackgroundColor(int innerBackgroundColor) {
        this.innerBackgroundColor = innerBackgroundColor;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measure(widthMeasureSpec), this.measure(heightMeasureSpec));
    }

    private int measure(int measureSpec) {
        int result;
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        if (mode == 0x40000000) {
            result = size;
        } else {
            result = this.min_size;
            if (mode == Integer.MIN_VALUE) {
                result = Math.min(result, size);
            }
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        float delta;
        super.onDraw(canvas);
        if (this.finishedStrokeWidth > this.unfinishedStrokeWidth) {
            this.finishedOuterRect.set(this.finishedStrokeWidth / 2.0f, this.finishedStrokeWidth / 2.0f, (float)this.getWidth() - this.finishedStrokeWidth / 2.0f, (float)this.getHeight() - this.finishedStrokeWidth / 2.0f);
            delta = (this.finishedStrokeWidth - this.unfinishedStrokeWidth) / 2.0f;
            this.unfinishedOuterRect.set(this.unfinishedStrokeWidth / 2.0f, this.unfinishedStrokeWidth / 2.0f, (float)this.getWidth() - this.unfinishedStrokeWidth / 2.0f - delta, (float)this.getHeight() - this.unfinishedStrokeWidth / 2.0f - delta);
        } else {
            delta = (this.unfinishedStrokeWidth - this.finishedStrokeWidth) / 2.0f;
            this.finishedOuterRect.set(this.finishedStrokeWidth / 2.0f, this.finishedStrokeWidth / 2.0f, (float)this.getWidth() - this.finishedStrokeWidth / 2.0f - delta, (float)this.getHeight() - this.finishedStrokeWidth / 2.0f - delta);
            this.unfinishedOuterRect.set(this.unfinishedStrokeWidth / 2.0f, this.unfinishedStrokeWidth / 2.0f, (float)this.getWidth() - this.unfinishedStrokeWidth / 2.0f, (float)this.getHeight() - this.unfinishedStrokeWidth / 2.0f);
        }
        float innerCircleRadius = ((float)this.getWidth() - Math.min(this.finishedStrokeWidth, this.unfinishedStrokeWidth) + Math.abs(this.finishedStrokeWidth - this.unfinishedStrokeWidth)) / 2.0f;
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, innerCircleRadius, this.innerCirclePaint);
        canvas.drawArc(this.finishedOuterRect, 0.0f, this.getProgressAngle(), false, this.finishedPaint);
        canvas.drawArc(this.unfinishedOuterRect, this.getProgressAngle(), 360.0f - this.getProgressAngle(), false, this.unfinishedPaint);
        String text = this.prefixText + this.progress + this.suffixText;
        if (!TextUtils.isEmpty((CharSequence)text)) {
            float textHeight = this.textPaint.descent() + this.textPaint.ascent();
            canvas.drawText(text, ((float)this.getWidth() - this.textPaint.measureText(text)) / 2.0f, ((float)this.getWidth() - textHeight) / 2.0f, this.textPaint);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putInt(INSTANCE_TEXT_COLOR, this.getTextColor());
        bundle.putFloat(INSTANCE_TEXT_SIZE, this.getTextSize());
        bundle.putInt(INSTANCE_FINISHED_STROKE_COLOR, this.getFinishedStrokeColor());
        bundle.putInt(INSTANCE_UNFINISHED_STROKE_COLOR, this.getUnfinishedStrokeColor());
        bundle.putInt(INSTANCE_MAX, this.getMax());
        bundle.putInt(INSTANCE_PROGRESS, this.getProgress());
        bundle.putString(INSTANCE_SUFFIX, this.getSuffixText());
        bundle.putString(INSTANCE_PREFIX, this.getPrefixText());
        bundle.putFloat(INSTANCE_FINISHED_STROKE_WIDTH, this.getFinishedStrokeWidth());
        bundle.putFloat(INSTANCE_UNFINISHED_STROKE_WIDTH, this.getUnfinishedStrokeWidth());
        bundle.putInt(INSTANCE_BACKGROUND_COLOR, this.getInnerBackgroundColor());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.textColor = bundle.getInt(INSTANCE_TEXT_COLOR);
            this.textSize = bundle.getFloat(INSTANCE_TEXT_SIZE);
            this.finishedStrokeColor = bundle.getInt(INSTANCE_FINISHED_STROKE_COLOR);
            this.unfinishedStrokeColor = bundle.getInt(INSTANCE_UNFINISHED_STROKE_COLOR);
            this.finishedStrokeWidth = bundle.getFloat(INSTANCE_FINISHED_STROKE_WIDTH);
            this.unfinishedStrokeWidth = bundle.getFloat(INSTANCE_UNFINISHED_STROKE_WIDTH);
            this.innerBackgroundColor = bundle.getInt(INSTANCE_BACKGROUND_COLOR);
            this.initPainters();
            this.setMax(bundle.getInt(INSTANCE_MAX));
            this.setProgress(bundle.getInt(INSTANCE_PROGRESS));
            this.prefixText = bundle.getString(INSTANCE_PREFIX);
            this.suffixText = bundle.getString(INSTANCE_SUFFIX);
            super.onRestoreInstanceState(bundle.getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }
}

