/*
 * Decompiled with CFR 0.152.
 */
package com.github.maasdi.react.assets;

import com.github.maasdi.react.assets.AssetContex;
import com.github.maasdi.react.assets.AssetManifest;
import com.github.maasdi.react.assets.ReactAssetsResource;
import com.github.maasdi.react.assets.builder.CssAssetBuilder;
import com.github.maasdi.react.assets.builder.JsAssetBuilder;
import com.github.maasdi.react.assets.builder.RuntimeAssetBuilder;
import com.github.maasdi.react.assets.processor.IAssetProcessor;
import com.github.maasdi.react.assets.processor.SimpleAssetProcessor;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="process-asset", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ReactAssetMojo
extends AbstractMojo {
    private Gson gson = new Gson();
    @Parameter(required=false, defaultValue="asset-manifest.json", readonly=true)
    private String manifestName;
    @Parameter(required=true, readonly=true)
    private List<ReactAssetsResource> resources;
    @Parameter(required=true, readonly=true)
    private File assetsDirectory;
    @Parameter(required=false, defaultValue="<ReactAssetCss/>", readonly=true)
    private String cssMarkup;
    @Parameter(required=false, defaultValue="<ReactAssetJs/>", readonly=true)
    private String jsMarkup;
    @Parameter(required=false, defaultValue="<ReactAssetRuntime/>", readonly=true)
    private String runtimeMarkup;
    @Parameter(required=false, defaultValue="/", readonly=true)
    private String publicUrl;
    @Parameter(required=false, defaultValue="true", readonly=true)
    private Boolean inlineRuntimeChunk;
    private IAssetProcessor processor = new SimpleAssetProcessor();

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Start processing " + this.manifestName));
            AssetManifest manifest = (AssetManifest)this.gson.fromJson((Reader)new FileReader(this.assetsDirectory.getPath() + File.separator + this.manifestName), AssetManifest.class);
            AssetContex ctx = new AssetContex();
            ctx.setLog(this.getLog());
            ctx.setResources(this.resources);
            ctx.setAssetsDirectory(this.assetsDirectory);
            ctx.setCssMarkup(this.cssMarkup);
            ctx.setJsMarkup(this.jsMarkup);
            ctx.setRuntimeMarkup(this.runtimeMarkup);
            ctx.setCssAsset(new CssAssetBuilder(this.publicUrl).build(manifest.getStyles()));
            ctx.setRuntimeAsset(new RuntimeAssetBuilder(ctx.getAssetsDirectory(), this.publicUrl, this.inlineRuntimeChunk).build(manifest.getRuntime()));
            ctx.setJsAsset(new JsAssetBuilder(this.publicUrl).build(manifest.getScripts()));
            this.processor.process(manifest, ctx);
            this.getLog().info((CharSequence)("End processing " + this.manifestName));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Error to process " + this.manifestName), (Throwable)e);
            throw new MojoExecutionException("Error to process resources", e);
        }
    }
}

