/*
 * Decompiled with CFR 0.152.
 */
package com.github.madgnome.maven.h2spec;

import com.github.madgnome.maven.h2spec.Failure;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.FileUtils;

public class H2SpecTestSuite {
    public static final String H2SPEC_VERSION = "2.1.1";

    public static void main(String[] args) throws IOException {
        H2SpecTestSuite.runH2Spec(new File(args[0]), Integer.parseInt(args[1]), 2, 4000, Collections.<String>emptySet());
    }

    public static String getSpecIdentifier(String specId, String name) {
        return specId + " - " + name;
    }

    public static List<Failure> runH2Spec(File targetDirectory, int port, int timeout, int maxHeaderLength, Set<String> excludeSpecs) throws IOException {
        File reportsDirectory = new File(targetDirectory, "reports");
        if (!reportsDirectory.exists()) {
            reportsDirectory.mkdir();
        }
        File junitFile = new File(reportsDirectory, "TEST-h2spec.xml");
        File h2spec = H2SpecTestSuite.getH2SpecFile(targetDirectory);
        DefaultExecutor exec = new DefaultExecutor();
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in);
        exec.setStreamHandler((ExecuteStreamHandler)psh);
        exec.setExitValues(new int[]{0, 1});
        psh.start();
        if (exec.execute(H2SpecTestSuite.buildCommandLine(h2spec, port, junitFile, timeout, maxHeaderLength)) != 0) {
            return H2SpecTestSuite.parseReports(reportsDirectory, excludeSpecs);
        }
        psh.stop();
        return Collections.emptyList();
    }

    private static List<Failure> parseReports(File reportsDirectory, Set<String> excludeSpecs) {
        SurefireReportParser parser = new SurefireReportParser(Collections.singletonList(reportsDirectory), Locale.getDefault());
        String currentPackageName = "";
        ArrayList<Failure> failures = new ArrayList<Failure>();
        try {
            List parsedReports = parser.parseXMLReportFiles();
            for (ReportTestSuite parsedReport : parsedReports) {
                String packageName = parsedReport.getPackageName();
                if (packageName.length() > 0) {
                    currentPackageName = packageName;
                }
                if (parsedReport.getNumberOfErrors() <= 0) continue;
                for (ReportTestCase reportTestCase : parsedReport.getTestCases()) {
                    String name = parsedReport.getFullClassName();
                    boolean ignored = excludeSpecs.contains(H2SpecTestSuite.getSpecIdentifier(currentPackageName, name));
                    String failureDetail = reportTestCase.getFailureDetail();
                    String[] failureTokens = failureDetail.split("\n");
                    String expected = failureTokens.length > 0 ? failureTokens[0] : "";
                    String actual = failureTokens.length > 1 ? failureTokens[1] : "";
                    failures.add(new Failure(name, currentPackageName, actual, expected, ignored));
                }
            }
        }
        catch (MavenReportException e) {
            e.printStackTrace();
        }
        return failures;
    }

    private static CommandLine buildCommandLine(File h2spec, int port, File junitFile, int timeout, int maxHeaderLength) {
        return CommandLine.parse((String)String.format("%s %s -p %d -j %s -o %d --max-header-length %d", h2spec.getAbsolutePath(), " ", port, junitFile.getAbsolutePath(), timeout, maxHeaderLength));
    }

    private static File getH2SpecFile(File targetDirectory) throws IOException {
        URL h2SpecArchiveInJar = H2SpecTestSuite.class.getResource(H2SpecTestSuite.getH2SpecArchivePathForOs());
        File h2SpecArchive = new File(targetDirectory, new File(h2SpecArchiveInJar.getPath()).getName());
        FileUtils.copyURLToFile((URL)h2SpecArchiveInJar, (File)h2SpecArchive);
        File h2Spec = new File(targetDirectory, "h2spec");
        Object unArchiver = h2SpecArchive.getName().endsWith(".tar.gz") ? new TarGZipUnArchiver() : new ZipUnArchiver();
        ((AbstractLogEnabled)unArchiver).enableLogging((Logger)new ConsoleLogger(0, "console"));
        unArchiver.setSourceFile(h2SpecArchive);
        unArchiver.setDestDirectory(targetDirectory);
        unArchiver.extract();
        if (!h2Spec.setExecutable(true)) {
            throw new RuntimeException("Can't set h2spec as executable");
        }
        return h2Spec;
    }

    private static String getH2SpecArchivePathForOs() {
        String fileName;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            fileName = "h2spec_windows_amd64.zip";
        } else if (os.contains("nix") || os.contains("nux") || os.contains("aix")) {
            fileName = "h2spec_linux_amd64.tar.gz";
        } else if (os.contains("mac")) {
            fileName = "h2spec_darwin_amd64.tar.gz";
        } else {
            throw new IllegalStateException("This OS is not supported.");
        }
        return String.format("/h2spec/%s/%s", H2SPEC_VERSION, fileName);
    }
}

