/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import org.wltea.analyzer.cfg.Configuration;
import org.wltea.analyzer.cfg.DefaultConfig;
import org.wltea.analyzer.dic.DictSegment;
import org.wltea.analyzer.dic.Hit;

public class Dictionary {
    private static Dictionary singleton;
    private DictSegment _MainDict;
    private DictSegment _StopWordDict;
    private DictSegment _QuantifierDict;
    private Configuration cfg;

    private Dictionary(Configuration cfg) {
        this.cfg = cfg;
        this.loadMainDict();
        this.loadStopWordDict();
        this.loadQuantifierDict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initial(Configuration cfg) {
        if (singleton != null) return;
        Class<Dictionary> clazz = Dictionary.class;
        synchronized (Dictionary.class) {
            if (singleton != null) return;
            singleton = new Dictionary(cfg);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Dictionary getSingleton() {
        if (singleton == null) {
            throw new IllegalStateException("\u8bcd\u5178\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528initial\u65b9\u6cd5");
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadDic(List<InputStream> inputStreamList) {
        if (singleton == null) {
            Configuration cfg = DefaultConfig.getInstance();
            Dictionary.initial(cfg);
        }
        for (InputStream is : inputStreamList) {
            try {
                String theWord;
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
                do {
                    if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                    Dictionary.singleton._MainDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
                } while (theWord != null);
            }
            catch (IOException ioe) {
                System.err.println("Other Dictionary loading exception.");
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void addWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.fillSegment(word.trim().toLowerCase().toCharArray());
            }
        }
    }

    public void disableWords(Collection<String> words) {
        if (words != null) {
            for (String word : words) {
                if (word == null) continue;
                Dictionary.singleton._MainDict.disableSegment(word.trim().toLowerCase().toCharArray());
            }
        }
    }

    public Hit matchInMainDict(char[] charArray) {
        return Dictionary.singleton._MainDict.match(charArray);
    }

    public Hit matchInMainDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._MainDict.match(charArray, begin, length);
    }

    public Hit matchInQuantifierDict(char[] charArray, int begin, int length) {
        return Dictionary.singleton._QuantifierDict.match(charArray, begin, length);
    }

    public Hit matchWithHit(char[] charArray, int currentIndex, Hit matchedHit) {
        DictSegment ds = matchedHit.getMatchedDictSegment();
        return ds.match(charArray, currentIndex, 1, matchedHit);
    }

    public boolean isStopWord(char[] charArray, int begin, int length) {
        return Dictionary.singleton._StopWordDict.match(charArray, begin, length).isMatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMainDict() {
        this._MainDict = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.cfg.getMainDictionary());
        if (is == null) {
            throw new RuntimeException("Main Dictionary not found!!!");
        }
        try {
            String theWord;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._MainDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            System.err.println("Main Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadExtDict();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtDict() {
        List<String> extDictFiles = this.cfg.getExtDictionarys();
        if (extDictFiles != null) {
            for (String extDictName : extDictFiles) {
                System.out.println("\u52a0\u8f7d\u6269\u5c55\u8bcd\u5178\uff1a" + extDictName);
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(extDictName);
                if (is == null) continue;
                try {
                    String theWord;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
                    do {
                        if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                        this._MainDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
                    } while (theWord != null);
                }
                catch (IOException ioe) {
                    System.err.println("Extension Dictionary loading exception.");
                    ioe.printStackTrace();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStopWordDict() {
        this._StopWordDict = new DictSegment(Character.valueOf('\u0000'));
        List<String> extStopWordDictFiles = this.cfg.getExtStopWordDictionarys();
        if (extStopWordDictFiles != null) {
            for (String extStopWordDictName : extStopWordDictFiles) {
                System.out.println("\u52a0\u8f7d\u6269\u5c55\u505c\u6b62\u8bcd\u5178\uff1a" + extStopWordDictName);
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(extStopWordDictName);
                if (is == null) continue;
                try {
                    String theWord;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
                    do {
                        if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                        this._StopWordDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
                    } while (theWord != null);
                }
                catch (IOException ioe) {
                    System.err.println("Extension Stop word Dictionary loading exception.");
                    ioe.printStackTrace();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQuantifierDict() {
        this._QuantifierDict = new DictSegment(Character.valueOf('\u0000'));
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.cfg.getQuantifierDicionary());
        if (is == null) {
            throw new RuntimeException("Quantifier Dictionary not found!!!");
        }
        try {
            String theWord;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"), 512);
            do {
                if ((theWord = br.readLine()) == null || "".equals(theWord.trim())) continue;
                this._QuantifierDict.fillSegment(theWord.trim().toLowerCase().toCharArray());
            } while (theWord != null);
        }
        catch (IOException ioe) {
            System.err.println("Quantifier Dictionary loading exception.");
            ioe.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

