/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.wltea.analyzer.dic.Dictionary;
import org.wltea.analyzer.lucene.IKTokenizer;
import org.wltea.analyzer.lucene.UpdateKeeper;

public class IKTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware,
UpdateKeeper.UpdateJob {
    private boolean useSmart;
    private ResourceLoader loader;
    private long lastUpdateTime = -1L;
    private String conf = "ik.conf";

    public IKTokenizerFactory(Map<String, String> args) {
        super(args);
        String useSmartArg = args.get("useSmart");
        this.setUseSmart(Boolean.parseBoolean(useSmartArg));
    }

    public Tokenizer create(AttributeFactory factory) {
        return new IKTokenizer(factory, this.useSmart());
    }

    public void inform(ResourceLoader resourceLoader) throws IOException {
        System.out.println(String.format(":::ik:::inform:::::::::::::::::::::::: %s", this.conf));
        this.loader = resourceLoader;
        this.update();
        if (this.conf != null && !this.conf.trim().isEmpty()) {
            UpdateKeeper.getInstance().register(this);
        }
    }

    @Override
    public void update() throws IOException {
        Properties p = this.canUpdate();
        if (p != null) {
            List<String> dicPaths = IKTokenizerFactory.SplitFileNames(p.getProperty("files"));
            ArrayList<InputStream> inputStreamList = new ArrayList<InputStream>();
            for (String path : dicPaths) {
                InputStream is;
                if (path == null || path.isEmpty() || (is = this.loader.openResource(path)) == null) continue;
                inputStreamList.add(is);
            }
            if (!inputStreamList.isEmpty()) {
                Dictionary.reloadDic(inputStreamList);
            }
        }
    }

    private Properties canUpdate() {
        try {
            if (this.conf == null) {
                return null;
            }
            Properties p = new Properties();
            InputStream confStream = this.loader.openResource(this.conf);
            p.load(confStream);
            confStream.close();
            String lastupdate = p.getProperty("lastupdate", "0");
            Long t = new Long(lastupdate);
            if (t > this.lastUpdateTime) {
                this.lastUpdateTime = t;
                String paths = p.getProperty("files");
                if (paths == null || paths.trim().isEmpty()) {
                    return null;
                }
                System.out.println("loading conf files success.");
                return p;
            }
            this.lastUpdateTime = t;
            return null;
        }
        catch (Exception e) {
            System.err.println("IK parsing conf NullPointerException~~~~~" + Arrays.toString(e.getStackTrace()));
            return null;
        }
    }

    private static List<String> SplitFileNames(String fileNames) {
        if (fileNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, fileNames.split("[,\\s]+"));
        return result;
    }

    private boolean useSmart() {
        return this.useSmart;
    }

    private void setUseSmart(boolean useSmart) {
        this.useSmart = useSmart;
    }
}

