/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.core;

import java.util.Stack;
import java.util.TreeSet;
import org.wltea.analyzer.core.AnalyzeContext;
import org.wltea.analyzer.core.Lexeme;
import org.wltea.analyzer.core.LexemePath;
import org.wltea.analyzer.core.QuickSortSet;

class IKArbitrator {
    IKArbitrator() {
    }

    void process(AnalyzeContext context, boolean useSmart) {
        LexemePath judgeResult;
        QuickSortSet.Cell headCell;
        QuickSortSet orgLexemes = context.getOrgLexemes();
        Lexeme orgLexeme = orgLexemes.pollFirst();
        LexemePath crossPath = new LexemePath();
        while (orgLexeme != null) {
            if (!crossPath.addCrossLexeme(orgLexeme)) {
                if (crossPath.size() == 1 || !useSmart) {
                    context.addLexemePath(crossPath);
                } else {
                    headCell = crossPath.getHead();
                    judgeResult = this.judge(headCell);
                    context.addLexemePath(judgeResult);
                }
                crossPath = new LexemePath();
                crossPath.addCrossLexeme(orgLexeme);
            }
            orgLexeme = orgLexemes.pollFirst();
        }
        if (crossPath.size() == 1 || !useSmart) {
            context.addLexemePath(crossPath);
        } else {
            headCell = crossPath.getHead();
            judgeResult = this.judge(headCell);
            context.addLexemePath(judgeResult);
        }
    }

    private LexemePath judge(QuickSortSet.Cell lexemeCell) {
        TreeSet<LexemePath> pathOptions = new TreeSet<LexemePath>();
        LexemePath option = new LexemePath();
        Stack<QuickSortSet.Cell> lexemeStack = this.forwardPath(lexemeCell, option);
        pathOptions.add(option.copy());
        while (!lexemeStack.isEmpty()) {
            QuickSortSet.Cell c = lexemeStack.pop();
            this.backPath(c.getLexeme(), option);
            this.forwardPath(c, option);
            pathOptions.add(option.copy());
        }
        return (LexemePath)pathOptions.first();
    }

    private Stack<QuickSortSet.Cell> forwardPath(QuickSortSet.Cell lexemeCell, LexemePath option) {
        Stack<QuickSortSet.Cell> conflictStack = new Stack<QuickSortSet.Cell>();
        for (QuickSortSet.Cell c = lexemeCell; c != null && c.getLexeme() != null; c = c.getNext()) {
            if (option.addNotCrossLexeme(c.getLexeme())) continue;
            conflictStack.push(c);
        }
        return conflictStack;
    }

    private void backPath(Lexeme l, LexemePath option) {
        while (option.checkCross(l)) {
            option.removeTail();
        }
    }
}

