/*
 * Decompiled with CFR 0.152.
 */
package com.github.magrifle.data.searchapi.aspect;

import com.github.magrifle.data.searchapi.SearchConfigurer;
import com.github.magrifle.data.searchapi.SearchKeyConfigurerService;
import com.github.magrifle.data.searchapi.SearchOperation;
import com.github.magrifle.data.searchapi.annotation.SearchApi;
import com.github.magrifle.data.searchapi.data.SearchBuilder;
import com.github.magrifle.data.searchapi.data.SearchKey;
import com.github.magrifle.data.searchapi.exception.SearchApiConfigurationException;
import com.github.magrifle.data.searchapi.exception.SearchKeyValidationException;
import com.github.magrifle.data.searchapi.specification.EntitySpecification;
import com.github.magrifle.data.searchapi.specification.SpecificationsBuilder;
import com.google.common.base.Joiner;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Aspect
public final class DataSearchApi {
    private static final Logger logger = LoggerFactory.getLogger(DataSearchApi.class);
    @Autowired
    private List<SearchConfigurer> searchConfigurers;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private static final Pattern SEARCH_FIELD_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]*$");
    private boolean checkConfigurationsOnStartup = true;

    @Pointcut(value="@annotation(searchApi)")
    public void methodsWithSearchApi(SearchApi searchApi) {
    }

    @Pointcut(value="within(@org.springframework.web.bind.annotation.RestController *) ||within(@org.springframework.stereotype.Controller *)")
    private void allPublicControllerMethodsPointcut() {
    }

    @Around(value="allPublicControllerMethodsPointcut() && methodsWithSearchApi(searchApi)")
    private Object buildSpecificationForMethod(ProceedingJoinPoint joinPoint, SearchApi searchApi) throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String queryParameter = URLDecoder.decode(request.getParameter(searchApi.queryString()), "UTF-8");
        if ((queryParameter == null || queryParameter.isEmpty()) && searchApi.failOnMissingQueryString()) {
            throw new SearchKeyValidationException("The required query parameter \"" + searchApi.queryString() + "\" is missing");
        }
        logger.debug("Got query string {}", (Object)queryParameter);
        String join = Joiner.on((String)"|").join(SearchOperation.SIMPLE_OPERATION_SET.keySet());
        Pattern pattern = Pattern.compile("(\\w+?)(" + join + ")(\\*|\\[?)([\\w\\s-.@]+?)(\\*|]?),");
        Matcher matcher = pattern.matcher(queryParameter + searchApi.keySeparator().getValue());
        Object[] args = joinPoint.getArgs();
        SearchConfigurer first = this.searchConfigurers.stream().filter(b -> b.getType() == searchApi.entity()).findFirst().orElseThrow(() -> new SearchApiConfigurationException("Could not find a configuration bean of " + SearchConfigurer.class.getName() + "<\"" + searchApi.entity() + "\">"));
        SpecificationsBuilder builder = new SpecificationsBuilder(new SearchKeyConfigurerService(first), searchApi.caseSensitive());
        while (matcher.find()) {
            builder.with(matcher.group(1), matcher.group(2), matcher.group(4), matcher.group(3), matcher.group(5));
        }
        EntitySpecification build = builder.build();
        EntitySpecification specification = build == null ? new EntitySpecification() : build;
        IntStream.range(0, args.length).filter(i -> args[i].getClass() == SearchBuilder.class).findFirst().ifPresent(i -> {
            args[i] = new SearchBuilder(specification);
        });
        return joinPoint.proceed(args);
    }

    @PostConstruct
    private void init() {
        if (this.checkConfigurationsOnStartup) {
            this.checkBeanConfigurations();
            this.validateSearchFields();
        }
    }

    private void checkBeanConfigurations() {
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        for (HandlerMethod handlerMethod : handlerMethods.values()) {
            SearchApi methodAnnotation = (SearchApi)handlerMethod.getMethodAnnotation(SearchApi.class);
            if (methodAnnotation == null) continue;
            Class type = methodAnnotation.entity();
            this.searchConfigurers.stream().filter(b -> b.getType() == type).findAny().orElseThrow(() -> new IllegalArgumentException("You have defined @" + SearchApi.class.getName() + "(entity=\"" + type + "\".class on method [" + handlerMethod.getMethod().getName() + "] but you have not created a bean of entity " + SearchConfigurer.class.getName() + "<\"" + type + "\">"));
        }
    }

    private void validateSearchFields() {
        this.searchConfigurers.stream().flatMap(i -> i.getSearchKeys().stream()).map(SearchKey::getName).filter(i -> !SEARCH_FIELD_PATTERN.matcher((CharSequence)i).matches()).findAny().ifPresent(i -> {
            throw new IllegalArgumentException("Invalid field name [" + i + "] defined. Valid pattern " + SEARCH_FIELD_PATTERN.pattern());
        });
    }
}

