/*
 * Decompiled with CFR 0.152.
 */
package com.github.magrifle.data.searchapi.specification;

import com.github.magrifle.data.searchapi.SearchOperation;
import com.github.magrifle.data.searchapi.data.SearchCriteria;
import java.util.Arrays;
import java.util.Date;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class EntitySpecification<T>
implements Specification<T> {
    private SearchCriteria criteria;

    public EntitySpecification() {
    }

    EntitySpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        Path path;
        if (this.criteria == null) {
            return null;
        }
        String[] joins = this.criteria.getKey().split("\\.");
        if (joins.length > 1) {
            Join join = root.join(joins[0]);
            path = this.criteria.getType() != null ? builder.treat(join, this.criteria.getType()).get(joins[1]) : join.get(joins[1]);
        } else {
            path = root.get(this.criteria.getKey());
            query.distinct(true);
        }
        return this.getCriteria(builder, path);
    }

    private Predicate getCriteria(CriteriaBuilder builder, Path path) {
        switch (this.criteria.getOperation()) {
            case EQUALITY: 
            case NEGATION: {
                Predicate predicate = this.isCaseInsensitive(this.criteria, path) ? builder.equal(builder.lower((Expression)path), (Object)this.criteria.getValue().toString().toLowerCase()) : builder.equal((Expression)path, this.criteria.getValue());
                return this.criteria.getOperation() == SearchOperation.NEGATION ? predicate.not() : predicate;
            }
            case GREATER_THAN: {
                return path.getJavaType() == Date.class ? builder.greaterThan((Expression)path, (Comparable)((Date)this.criteria.getValue())) : builder.greaterThan((Expression)path, (Comparable)((Object)this.criteria.getValue().toString()));
            }
            case LESS_THAN: {
                return path.getJavaType() == Date.class ? builder.lessThan((Expression)path, (Comparable)((Date)this.criteria.getValue())) : builder.lessThan((Expression)path, (Comparable)((Object)this.criteria.getValue().toString()));
            }
            case LIKE: {
                return this.isCaseInsensitive(this.criteria, path) ? builder.like(builder.lower((Expression)path), this.criteria.getValue().toString().toLowerCase()) : builder.like((Expression)path, this.criteria.getValue().toString());
            }
            case STARTS_WITH: {
                return this.isCaseInsensitive(this.criteria, path) ? builder.like(builder.lower((Expression)path), this.criteria.getValue().toString().toLowerCase() + "%") : builder.like((Expression)path, this.criteria.getValue() + "%");
            }
            case ENDS_WITH: {
                return this.isCaseInsensitive(this.criteria, path) ? builder.like(builder.lower((Expression)path), "%" + this.criteria.getValue().toString().toLowerCase()) : builder.like((Expression)path, "%" + this.criteria.getValue());
            }
            case CONTAINS: {
                return this.isCaseInsensitive(this.criteria, path) ? builder.like(builder.lower((Expression)path), "%" + this.criteria.getValue().toString().toLowerCase() + "%") : builder.like((Expression)path, "%" + this.criteria.getValue() + "%");
            }
            case IN: {
                CriteriaBuilder.In inClause = this.isCaseInsensitive(this.criteria, path) ? builder.in(builder.lower((Expression)path)) : builder.in((Expression)path);
                Arrays.asList(this.criteria.getValue().toString().split("_")).forEach(v -> {
                    if (path.getJavaType().isAssignableFrom(Long.class)) {
                        inClause.value((Object)Long.valueOf(v));
                    } else if (this.isCaseInsensitive(this.criteria, path)) {
                        inClause.value((Object)v.toLowerCase());
                    } else {
                        inClause.value(v);
                    }
                });
                return inClause;
            }
        }
        return null;
    }

    private boolean isCaseInsensitive(SearchCriteria criteria, Path path) {
        return !criteria.isCaseSensitive() && path.getJavaType() == String.class;
    }
}

