/*
 * Decompiled with CFR 0.152.
 */
package com.github.magrifle.data.searchapi.specification;

import com.github.magrifle.data.searchapi.SearchKeyConfigurerService;
import com.github.magrifle.data.searchapi.SearchOperation;
import com.github.magrifle.data.searchapi.data.SearchCriteria;
import com.github.magrifle.data.searchapi.specification.EntitySpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.data.jpa.domain.Specification;

public class SpecificationsBuilder<T> {
    private final SearchKeyConfigurerService<T> searchKeyConfigurerService;
    private final boolean caseSensitive;
    private List<SearchCriteria> params = new ArrayList<SearchCriteria>();

    public SpecificationsBuilder(SearchKeyConfigurerService<T> searchKeyConfigurerService, boolean caseSensitive) {
        this.searchKeyConfigurerService = searchKeyConfigurerService;
        this.caseSensitive = caseSensitive;
    }

    public SpecificationsBuilder with(String key, String operation, Object value, String prefix, String suffix) {
        SearchOperation op = SearchOperation.SIMPLE_OPERATION_SET.get(Character.valueOf(operation.charAt(0)));
        if (op != null) {
            if (op == SearchOperation.EQUALITY) {
                boolean startWithAsterisk = prefix.equals("*");
                boolean endWithAsterisk = suffix.equals("*");
                if (startWithAsterisk && endWithAsterisk) {
                    op = SearchOperation.CONTAINS;
                } else if (startWithAsterisk) {
                    op = SearchOperation.ENDS_WITH;
                } else if (endWithAsterisk) {
                    op = SearchOperation.STARTS_WITH;
                } else if (prefix.equals("[") && suffix.equals("]")) {
                    op = SearchOperation.IN;
                }
            }
            SearchCriteria searchCriteria = new SearchCriteria(key, op, value);
            searchCriteria.setCaseSensitive(this.caseSensitive);
            this.params.add(searchCriteria);
        }
        return this;
    }

    public Specification<T> build() {
        if (this.params.size() == 0) {
            return null;
        }
        this.searchKeyConfigurerService.prepareSearchData(this.params);
        ArrayList specs = new ArrayList();
        for (SearchCriteria param : this.params) {
            specs.add(new EntitySpecification(param));
        }
        Specification result = (Specification)specs.get(0);
        for (int i = 1; i < specs.size(); ++i) {
            result = Objects.requireNonNull(Specification.where((Specification)result)).and((Specification)specs.get(i));
        }
        return result;
    }
}

