/*
 * Decompiled with CFR 0.152.
 */
package com.github.maltalex.ineter.base;

import com.github.maltalex.ineter.base.IPAddress;
import com.github.maltalex.ineter.range.IPv4Range;
import com.github.maltalex.ineter.range.IPv4Subnet;
import java.net.Inet4Address;

public class IPv4Address
extends IPAddress
implements Comparable<IPv4Address> {
    public static final int ADDRESS_BITS = 32;
    public static final int ADDRESS_BYTES = 4;
    private static final long serialVersionUID = 1L;
    protected final int ip;

    public static IPv4Address of(byte[] bigEndianByteArr) {
        if (bigEndianByteArr == null) {
            throw new NullPointerException("The given array is null");
        }
        if (bigEndianByteArr.length != 4) {
            throw new IllegalArgumentException(String.format("The array has to be 4 bytes long, the given array is %d bytes long", bigEndianByteArr.length));
        }
        return new IPv4Address(IPv4Address.shiftToInt(bigEndianByteArr[0], bigEndianByteArr[1], bigEndianByteArr[2], bigEndianByteArr[3]));
    }

    public static IPv4Address of(int intIp) {
        return new IPv4Address(intIp);
    }

    public static IPv4Address of(String ip) {
        int d;
        int c;
        int b;
        if (ip == null) {
            throw new NullPointerException("String IP address is null");
        }
        if (ip.length() < 7 || ip.length() > 15) {
            throw new IllegalArgumentException("Invalid IP address length");
        }
        String[] split = ip.split("\\.");
        if (split.length != 4) {
            throw new IllegalArgumentException("IPv4 addresses must have exactly 4 octets");
        }
        int a = Integer.parseInt(split[0]);
        if (((a | (b = Integer.parseInt(split[1])) | (c = Integer.parseInt(split[2])) | (d = Integer.parseInt(split[3]))) & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("All octets have to be between 0 and 255");
        }
        return IPv4Address.of(IPv4Address.shiftToInt(a, b, c, d));
    }

    public static IPv4Address of(Inet4Address address) {
        return IPv4Address.of(address.getAddress());
    }

    protected static int shiftToInt(int a, int b, int c, int d) {
        return a << 24 | b << 16 | c << 8 | d;
    }

    protected static int shiftToInt(byte a, byte b, byte c, byte d) {
        return IPv4Address.shiftToInt(a & 0xFF, b & 0xFF, c & 0xFF, d & 0xFF);
    }

    public IPv4Address(int intIp) {
        this.ip = intIp;
    }

    @Override
    public int version() {
        return 4;
    }

    @Override
    public int compareTo(IPv4Address o) {
        if (o == null) {
            return 1;
        }
        if (this.ip == o.ip) {
            return 0;
        }
        return this.ip + Integer.MIN_VALUE < o.toInt() + Integer.MIN_VALUE ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPv4Address)) {
            return false;
        }
        return ((IPv4Address)obj).ip == this.ip;
    }

    public int hashCode() {
        return this.ip;
    }

    @Override
    public boolean is6To4() {
        return IPv4KnownRange.TRANSLATION_6_TO_4.contains(this);
    }

    public boolean isBroadcast() {
        return IPv4KnownRange.BROADCAST.contains(this);
    }

    @Override
    public boolean isMartian() {
        return this.isReserved() || this.isPrivate() || this.is6To4() || this.isBroadcast() || this.isLinkLocal() || this.isMulticast() || this.isLoopback() || this.isUnspecified();
    }

    @Override
    public boolean isLinkLocal() {
        return IPv4KnownRange.LINK_LOCAL.contains(this);
    }

    @Override
    public boolean isLoopback() {
        return IPv4KnownRange.LOOPBACK.contains(this);
    }

    @Override
    public boolean isMulticast() {
        return IPv4KnownRange.MULTICAST.contains(this);
    }

    @Override
    public boolean isPrivate() {
        return IPv4KnownRange.PRIVATE_10.contains(this) || IPv4KnownRange.PRIVATE_172_16.contains(this) || IPv4KnownRange.PRIVATE_192_168.contains(this) || IPv4KnownRange.CGNAT.contains(this);
    }

    @Override
    public boolean isReserved() {
        return IPv4KnownRange.RESERVED_240.contains(this) || IPv4KnownRange.SPECIAL_PURPOSE.contains(this) || IPv4KnownRange.TEST_NET1.contains(this) || IPv4KnownRange.TEST_NET2.contains(this) || IPv4KnownRange.TEST_NET3.contains(this) || IPv4KnownRange.TESTING.contains(this);
    }

    @Override
    public boolean isUnspecified() {
        return IPv4KnownRange.UNSPECIFIED.contains(this);
    }

    @Override
    public IPv4Address next() {
        return this.plus(1);
    }

    @Override
    public IPv4Address plus(int n) {
        return new IPv4Address((int)(this.toLong() + (long)n));
    }

    @Override
    public IPv4Address previous() {
        return this.minus(1);
    }

    @Override
    public IPv4Address minus(int n) {
        return new IPv4Address((int)(this.toLong() - (long)n));
    }

    @Override
    public byte[] toBigEndianArray() {
        return new byte[]{Ip4Octet.OCTET_A.isolateAsByte(this.ip), Ip4Octet.OCTET_B.isolateAsByte(this.ip), Ip4Octet.OCTET_C.isolateAsByte(this.ip), Ip4Octet.OCTET_D.isolateAsByte(this.ip)};
    }

    public Inet4Address toInet4Address() {
        return (Inet4Address)this.toInetAddress();
    }

    @Override
    public byte[] toLittleEndianArray() {
        return new byte[]{Ip4Octet.OCTET_D.isolateAsByte(this.ip), Ip4Octet.OCTET_C.isolateAsByte(this.ip), Ip4Octet.OCTET_B.isolateAsByte(this.ip), Ip4Octet.OCTET_A.isolateAsByte(this.ip)};
    }

    public String toString() {
        return String.join((CharSequence)".", Integer.toString(Ip4Octet.OCTET_A.isolateAsInt(this.ip)), Integer.toString(Ip4Octet.OCTET_B.isolateAsInt(this.ip)), Integer.toString(Ip4Octet.OCTET_C.isolateAsInt(this.ip)), Integer.toString(Ip4Octet.OCTET_D.isolateAsInt(this.ip)));
    }

    public int toInt() {
        return this.ip;
    }

    public long toLong() {
        return (long)this.ip & 0xFFFFFFFFL;
    }

    protected static enum Ip4Octet {
        OCTET_A(0),
        OCTET_B(1),
        OCTET_C(2),
        OCTET_D(3);

        private final int mask;
        private final int shift;

        private Ip4Octet(int byteShift) {
            this.shift = 24 - (byteShift << 3);
            this.mask = -16777216 >>> (byteShift << 3);
        }

        public int isolateAsInt(int ip) {
            return (ip & this.mask) >>> this.shift;
        }

        public byte isolateAsByte(int ip) {
            return (byte)this.isolateAsInt(ip);
        }
    }

    public static enum IPv4KnownRange {
        LOOPBACK(IPv4Subnet.of("127.0.0.0/8")),
        UNSPECIFIED(IPv4Subnet.of("0.0.0.0/8")),
        PRIVATE_10(IPv4Subnet.of("10.0.0.0/8")),
        PRIVATE_172_16(IPv4Subnet.of("172.16.0.0/12")),
        PRIVATE_192_168(IPv4Subnet.of("192.168.0.0/16")),
        TESTING(IPv4Subnet.of("198.18.0.0/15")),
        TRANSLATION_6_TO_4(IPv4Subnet.of("192.88.99.0/24")),
        LINK_LOCAL(IPv4Subnet.of("169.254.0.0/16")),
        SPECIAL_PURPOSE(IPv4Subnet.of("192.0.0.0/24")),
        TEST_NET1(IPv4Subnet.of("192.0.2.0/24")),
        TEST_NET2(IPv4Subnet.of("198.51.100.0/24")),
        TEST_NET3(IPv4Subnet.of("203.0.113.0/24")),
        MULTICAST(IPv4Subnet.of("224.0.0.0/4")),
        CGNAT(IPv4Subnet.of("100.64.0.0/10")),
        RESERVED_240(IPv4Subnet.of("240.0.0.0/4")),
        BROADCAST(IPv4Subnet.of("255.255.255.255/32"));

        private IPv4Range range;

        private IPv4KnownRange(IPv4Range range) {
            this.range = range;
        }

        public boolean contains(IPv4Address address) {
            return this.range.contains(address);
        }

        public IPv4Range range() {
            return this.range;
        }
    }
}

