/*
 * Decompiled with CFR 0.152.
 */
package com.github.maltalex.ineter.base;

import com.github.maltalex.ineter.base.IPAddress;
import com.github.maltalex.ineter.base.ZonedIPv6Address;
import com.github.maltalex.ineter.range.IPv6Range;
import com.github.maltalex.ineter.range.IPv6Subnet;
import java.net.Inet6Address;

public class IPv6Address
extends IPAddress
implements Comparable<IPv6Address> {
    public static final int ADDRESS_BITS = 128;
    public static final int ADDRESS_BYTES = 16;
    public static final int ADDRESS_SHORTS = 8;
    public static final int HOLDER_BITS = 64;
    private static final long serialVersionUID = 1L;
    protected final long upper;
    protected final long lower;

    public static IPv6Address of(long upper, long lower) {
        return new IPv6Address(upper, lower);
    }

    protected static void verifyArray(byte[] bigEndianByteArr) {
        if (bigEndianByteArr == null) {
            throw new NullPointerException();
        }
        if (bigEndianByteArr.length != 16) {
            throw new IllegalArgumentException("The given array must be 16 bytes long");
        }
    }

    public static IPv6Address of(byte[] bigEndianByteArr) {
        IPv6Address.verifyArray(bigEndianByteArr);
        return new IPv6Address(LongByte.extractLong(bigEndianByteArr, 0), LongByte.extractLong(bigEndianByteArr, 8));
    }

    public static IPv6Address of(Inet6Address address) {
        if (address.getScopeId() == 0 && address.getScopedInterface() == null) {
            return IPv6Address.of(address.getAddress());
        }
        return ZonedIPv6Address.of(address);
    }

    public static IPv6Address of(String address) {
        int length;
        char ch;
        if (address == null) {
            throw new IllegalArgumentException("Attempted to parse null address");
        }
        int first = 0;
        int last = address.length();
        if (address.length() < 2) {
            throw new IllegalArgumentException(String.format("Invalid length - the string %s is too short to be an IPv6 address", address));
        }
        if (address.charAt(0) == '[') {
            ++first;
            if (address.charAt(--last) != ']') {
                throw new IllegalArgumentException("The address begins with \"[\" but doesn't end with \"]\"");
            }
        }
        String zone = null;
        for (int i = last - 1; i > first && (ch = address.charAt(i)) != ':'; --i) {
            if (ch != '%') continue;
            zone = address.substring(i + 1, last);
            last = i;
            break;
        }
        if ((length = last - first) > 39) {
            throw new IllegalArgumentException(String.format("Invalid length - the string %s is too long to be an IPv6 address. Length: %d", address, address.length()));
        }
        long partAccumulator = 0L;
        long upperAccumulator = 0L;
        long lowerAccumulator = 0L;
        int partIndex = 0;
        int afterDoubleSemicolonIndex = last + 2;
        int partCount = 1;
        int partHexDigitCount = 0;
        for (int i = first; i < last; ++i) {
            char c = address.charAt(i);
            if (IPv6Address.isHexDigit(c)) {
                if (++partHexDigitCount > 4) {
                    throw new IllegalArgumentException("Address parts must contain no more than 16 bits (4 hex digits)");
                }
                partAccumulator = partAccumulator << 4 | (long)(Character.digit(c, 16) & 0xFFFF);
                continue;
            }
            if (c == ':') {
                if (partIndex < 4) {
                    upperAccumulator |= partAccumulator << 48 - (partIndex << 4);
                } else {
                    lowerAccumulator |= partAccumulator << 48 - (partIndex - 4 << 4);
                }
                ++partIndex;
                ++partCount;
                partAccumulator = 0L;
                partHexDigitCount = 0;
                if (i >= last - 1 || address.charAt(i + 1) != ':') continue;
                afterDoubleSemicolonIndex = i + 2;
                break;
            }
            throw new IllegalArgumentException(String.format("Illegal character: %c at index %d", Character.valueOf(c), i));
        }
        int lastFilledPartIndex = partIndex - 1;
        partIndex = 7;
        for (int i = last - 1; i >= afterDoubleSemicolonIndex; --i) {
            char c = address.charAt(i);
            if (IPv6Address.isHexDigit(c)) {
                if (partIndex <= lastFilledPartIndex) {
                    throw new IllegalArgumentException("Too many parts. Expected 8 parts");
                }
                partAccumulator |= (long)((Character.digit(c, 16) & 0xFFFF) << (partHexDigitCount << 2));
                if (++partHexDigitCount <= 4) continue;
                throw new IllegalArgumentException("Address parts must contain no more than 16 bits (4 hex digits)");
            }
            if (c == ':') {
                if (partIndex < 4) {
                    upperAccumulator |= partAccumulator << 48 - (partIndex << 4);
                } else {
                    lowerAccumulator |= partAccumulator << 48 - (partIndex - 4 << 4);
                }
                if (address.charAt(i - 1) == ':') {
                    throw new IllegalArgumentException(String.format("Error at index %d - unexpected colon", i));
                }
                ++partCount;
                --partIndex;
                partAccumulator = 0L;
                partHexDigitCount = 0;
                continue;
            }
            throw new IllegalArgumentException(String.format("Illegal character: %c at index %d", Character.valueOf(c), i));
        }
        if (partIndex < 4) {
            upperAccumulator |= partAccumulator << 48 - (partIndex << 4);
        } else {
            lowerAccumulator |= partAccumulator << 48 - (partIndex - 4 << 4);
        }
        if (partCount > 8 || partCount < 8 && afterDoubleSemicolonIndex == last + 2) {
            throw new IllegalArgumentException(String.format("Invalid number of parts. Expected 8, got %d", partCount));
        }
        return zone == null ? new IPv6Address(upperAccumulator, lowerAccumulator) : new ZonedIPv6Address(upperAccumulator, lowerAccumulator, zone);
    }

    protected static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    protected static int unsignedCompare(long a, long b) {
        if (a == b) {
            return 0;
        }
        return a + Long.MIN_VALUE < b + Long.MIN_VALUE ? -1 : 1;
    }

    static boolean hasCarry(long a, long b, long result) {
        long aMSB = a >>> 63;
        long bMSB = b >>> 63;
        long resutlMSB = result >>> 63;
        return (aMSB & bMSB) == 1L || (aMSB ^ bMSB) == 1L && resutlMSB == 0L;
    }

    static boolean hasBorrow(long a, long b, long result) {
        long aMSB = a >>> 63;
        long bMSB = b >>> 63;
        long resutlMSB = result >>> 63;
        return (aMSB & bMSB & resutlMSB) == 1L || aMSB == 0L && (bMSB | resutlMSB) == 1L;
    }

    public IPv6Address(long upper, long lower) {
        this.upper = upper;
        this.lower = lower;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (int)(this.lower ^ this.lower >>> 32);
        result = prime * result + (int)(this.upper ^ this.upper >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPv6Address other = (IPv6Address)obj;
        if (this.lower != other.lower) {
            return false;
        }
        return this.upper == other.upper;
    }

    public long getUpper() {
        return this.upper;
    }

    public long getLower() {
        return this.lower;
    }

    @Override
    public boolean is6To4() {
        return IPv6KnownRange.TRANSLATION_6_TO_4.contains(this);
    }

    @Override
    public boolean isMartian() {
        return this.isUnspecified() || this.isLoopback() || IPv6KnownRange.IPV4_MAPPED_IPV6.contains(this) || IPv6KnownRange.IPV4_COMPATIBLE_IPV6_DEPRECATED.contains(this) || IPv6KnownRange.IPV4_IPV6_TRANSLATION_WELL_KNOWN.contains(this) || this.isReserved() || this.isPrivate() || this.isLinkLocal() || this.isMulticast() && !IPv6KnownRange.GLOBAL_MULTICAST.contains(this);
    }

    public boolean isIPv4Translation() {
        return IPv6KnownRange.TEREDO.contains(this) || IPv6KnownRange.IPV4_MAPPED_IPV6.contains(this) || IPv6KnownRange.TRANSLATION_6_TO_4.contains(this) || IPv6KnownRange.IPV4_IPV6_TRANSLATION_WELL_KNOWN.contains(this);
    }

    @Override
    public boolean isLoopback() {
        return IPv6KnownRange.LOOPBACK.contains(this);
    }

    public boolean isGlobalUnicast() {
        return IPv6KnownRange.GLOBAL_UNICAST.contains(this);
    }

    @Override
    public boolean isLinkLocal() {
        return IPv6KnownRange.LINK_LOCAL_UNICAST.contains(this);
    }

    @Override
    public boolean isMulticast() {
        return IPv6KnownRange.MULTICAST.contains(this);
    }

    @Override
    public boolean isPrivate() {
        return IPv6KnownRange.ULA.contains(this);
    }

    @Override
    public boolean isReserved() {
        return IPv6KnownRange.ORCHID.contains(this) || IPv6KnownRange.ORCHID_2.contains(this) || IPv6KnownRange.DISCARD.contains(this) || IPv6KnownRange.DOCUMENTATION.contains(this);
    }

    @Override
    public boolean isUnspecified() {
        return IPv6KnownRange.UNSPECIFIED.contains(this);
    }

    @Override
    public IPv6Address next() {
        return this.plus(1);
    }

    public IPv6Address plus(long n) {
        if (n < 0L) {
            return this.minus(-n);
        }
        long newLower = this.lower + n;
        long newUpper = this.upper;
        if (IPv6Address.hasCarry(this.lower, n, newLower)) {
            ++newUpper;
        }
        return new IPv6Address(newUpper, newLower);
    }

    @Override
    public IPv6Address plus(int n) {
        return this.plus((long)n);
    }

    @Override
    public IPv6Address previous() {
        return this.minus(1);
    }

    @Override
    public IPv6Address minus(int n) {
        return this.minus((long)n);
    }

    public IPv6Address minus(long n) {
        if (n < 0L) {
            return this.plus(-n);
        }
        long newLower = this.lower - n;
        long newUpper = this.upper;
        if (IPv6Address.hasBorrow(this.lower, n, newLower)) {
            --newUpper;
        }
        return new IPv6Address(newUpper, newLower);
    }

    @Override
    public byte[] toBigEndianArray() {
        return new byte[]{LongByte.BYTE_A.isolateAsByte(this.upper), LongByte.BYTE_B.isolateAsByte(this.upper), LongByte.BYTE_C.isolateAsByte(this.upper), LongByte.BYTE_D.isolateAsByte(this.upper), LongByte.BYTE_E.isolateAsByte(this.upper), LongByte.BYTE_F.isolateAsByte(this.upper), LongByte.BYTE_G.isolateAsByte(this.upper), LongByte.BYTE_H.isolateAsByte(this.upper), LongByte.BYTE_A.isolateAsByte(this.lower), LongByte.BYTE_B.isolateAsByte(this.lower), LongByte.BYTE_C.isolateAsByte(this.lower), LongByte.BYTE_D.isolateAsByte(this.lower), LongByte.BYTE_E.isolateAsByte(this.lower), LongByte.BYTE_F.isolateAsByte(this.lower), LongByte.BYTE_G.isolateAsByte(this.lower), LongByte.BYTE_H.isolateAsByte(this.lower)};
    }

    @Override
    public byte[] toLittleEndianArray() {
        return new byte[]{LongByte.BYTE_H.isolateAsByte(this.lower), LongByte.BYTE_G.isolateAsByte(this.lower), LongByte.BYTE_F.isolateAsByte(this.lower), LongByte.BYTE_E.isolateAsByte(this.lower), LongByte.BYTE_D.isolateAsByte(this.lower), LongByte.BYTE_C.isolateAsByte(this.lower), LongByte.BYTE_B.isolateAsByte(this.lower), LongByte.BYTE_A.isolateAsByte(this.lower), LongByte.BYTE_H.isolateAsByte(this.upper), LongByte.BYTE_G.isolateAsByte(this.upper), LongByte.BYTE_F.isolateAsByte(this.upper), LongByte.BYTE_E.isolateAsByte(this.upper), LongByte.BYTE_D.isolateAsByte(this.upper), LongByte.BYTE_C.isolateAsByte(this.upper), LongByte.BYTE_B.isolateAsByte(this.upper), LongByte.BYTE_A.isolateAsByte(this.upper)};
    }

    @Override
    public int compareTo(IPv6Address o) {
        if (o == null) {
            return 1;
        }
        if (o.isZoned()) {
            return -1;
        }
        return this.longCompare(o);
    }

    protected int longCompare(IPv6Address o) {
        int upperCompare = IPv6Address.unsignedCompare(this.upper, o.upper);
        return upperCompare == 0 ? IPv6Address.unsignedCompare(this.lower, o.lower) : upperCompare;
    }

    public Inet6Address toInet6Address() {
        return (Inet6Address)super.toInetAddress();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(39);
        builder.append(Integer.toHexString(LongShort.SHORT_A.isolateAsInt(this.upper)));
        builder.append(":");
        builder.append(Integer.toHexString(LongShort.SHORT_B.isolateAsInt(this.upper)));
        builder.append(":");
        builder.append(Integer.toHexString(LongShort.SHORT_C.isolateAsInt(this.upper)));
        builder.append(":");
        builder.append(Integer.toHexString(LongShort.SHORT_D.isolateAsInt(this.upper)));
        builder.append(":");
        builder.append(Integer.toHexString(LongShort.SHORT_A.isolateAsInt(this.lower)));
        builder.append(":");
        builder.append(Integer.toHexString(LongShort.SHORT_B.isolateAsInt(this.lower)));
        builder.append(":");
        builder.append(Integer.toHexString(LongShort.SHORT_C.isolateAsInt(this.lower)));
        builder.append(":");
        builder.append(Integer.toHexString(LongShort.SHORT_D.isolateAsInt(this.lower)));
        return builder.toString();
    }

    @Override
    public int version() {
        return 6;
    }

    public boolean isZoned() {
        return false;
    }

    protected static enum LongByte {
        BYTE_A(0),
        BYTE_B(1),
        BYTE_C(2),
        BYTE_D(3),
        BYTE_E(4),
        BYTE_F(5),
        BYTE_G(6),
        BYTE_H(7);

        private final long mask;
        private final int shift;

        private LongByte(int shortShift) {
            this.shift = 56 - (shortShift << 3);
            this.mask = -72057594037927936L >>> (shortShift << 3);
        }

        public long isolateAsLong(long l) {
            return (l & this.mask) >>> this.shift;
        }

        public byte isolateAsByte(long l) {
            return (byte)this.isolateAsLong(l);
        }

        public long expand(byte b) {
            return ((long)b & 0xFFL) << this.shift;
        }

        static long extractLong(byte[] bigEndianByteArr, int offset) {
            return BYTE_A.expand(bigEndianByteArr[offset]) | BYTE_B.expand(bigEndianByteArr[offset + 1]) | BYTE_C.expand(bigEndianByteArr[offset + 2]) | BYTE_D.expand(bigEndianByteArr[offset + 3]) | BYTE_E.expand(bigEndianByteArr[offset + 4]) | BYTE_F.expand(bigEndianByteArr[offset + 5]) | BYTE_G.expand(bigEndianByteArr[offset + 6]) | BYTE_H.expand(bigEndianByteArr[offset + 7]);
        }
    }

    protected static enum LongShort {
        SHORT_A(0),
        SHORT_B(1),
        SHORT_C(2),
        SHORT_D(3);

        private final long mask;
        private final int shift;

        private LongShort(int shortShift) {
            this.shift = 48 - (shortShift << 4);
            this.mask = -281474976710656L >>> (shortShift << 4);
        }

        public long isolateAsLong(long l) {
            return (l & this.mask) >>> this.shift;
        }

        public int isolateAsInt(long l) {
            return (int)this.isolateAsLong(l);
        }
    }

    public static enum IPv6KnownRange {
        UNSPECIFIED(IPv6Subnet.of("::/128")),
        LOOPBACK(IPv6Subnet.of("::1/128")),
        DISCARD(IPv6Subnet.of("100::/64")),
        ORCHID(IPv6Subnet.of("2001:10::/28")),
        ORCHID_2(IPv6Subnet.of("2001:20::/28")),
        DOCUMENTATION(IPv6Subnet.of("2001:db8::/32")),
        IPV4_COMPATIBLE_IPV6_DEPRECATED(IPv6Subnet.of("::/96")),
        IPV4_MAPPED_IPV6(IPv6Subnet.of("::ffff:0:0/96")),
        IPV4_IPV6_TRANSLATION_WELL_KNOWN(IPv6Subnet.of("64:ff9b::/96")),
        TRANSLATION_6_TO_4(IPv6Subnet.of("2002::/16")),
        TEREDO(IPv6Subnet.of("2001::/32")),
        ULA(IPv6Subnet.of("fc00::/7")),
        MULTICAST(IPv6Subnet.of("ff00::/8")),
        GLOBAL_MULTICAST(IPv6Subnet.of("ff0e::/16")),
        SITE_LOCAL_MULTICAST(IPv6Subnet.of("ff05::/16")),
        LINK_LOCAL_MULTICAST(IPv6Subnet.of("ff02::/16")),
        INTERFACE_LOCAL_MULTICAST(IPv6Subnet.of("ff01::/16")),
        GLOBAL_UNICAST(IPv6Subnet.of("2000::/3")),
        LINK_LOCAL_UNICAST(IPv6Subnet.of("fe80::/10")),
        SITE_LOCAL_UNICAST_DEPRECATED(IPv6Subnet.of("fec::/10"));

        private IPv6Range range;

        private IPv6KnownRange(IPv6Range subnet) {
            this.range = subnet;
        }

        public boolean contains(IPv6Address address) {
            return this.range.contains(address);
        }

        public IPv6Range range() {
            return this.range;
        }
    }
}

