/*
 * Decompiled with CFR 0.152.
 */
package com.github.maltalex.ineter.range;

import com.github.maltalex.ineter.base.IPv4Address;
import com.github.maltalex.ineter.range.IPSubnet;
import com.github.maltalex.ineter.range.IPv4Range;

public class IPv4Subnet
extends IPv4Range
implements IPSubnet<IPv4Address> {
    private static final long serialVersionUID = 1L;
    protected final byte networkBitCount;

    public static IPv4Subnet of(String cidr) {
        String[] cidrSplit = cidr.split("/");
        return new IPv4Subnet(IPv4Address.of(cidrSplit[0]), IPv4SubnetMask.fromMaskLen(Byte.parseByte(cidrSplit[1])));
    }

    public static IPv4Subnet of(String address, byte maskLen) {
        return new IPv4Subnet(IPv4Address.of(address), IPv4SubnetMask.fromMaskLen(maskLen));
    }

    public static IPv4Subnet of(IPv4Address address, byte maskLen) {
        return new IPv4Subnet(address, IPv4SubnetMask.fromMaskLen(maskLen));
    }

    public static IPv4Subnet parse(String from) throws IllegalArgumentException {
        return IPv4Subnet.parseSubnet(from, IPv4Subnet::of, 32);
    }

    static IPv4Subnet of(String address, Integer subnet) {
        return IPv4Subnet.of(address, subnet.byteValue());
    }

    public IPv4Subnet(IPv4Address address, IPv4SubnetMask mask) {
        super(mask.and(address), mask.orInverted(address));
        this.networkBitCount = mask.maskBitCount();
    }

    @Override
    public String toString() {
        return String.format("%s/%d", this.firstAddress, this.networkBitCount);
    }

    @Override
    public int getNetworkBitCount() {
        return this.networkBitCount;
    }

    @Override
    public IPv4Address getNetworkMask() {
        return IPv4SubnetMask.fromMaskLen(this.networkBitCount).toAddress();
    }

    @Override
    public int getHostBitCount() {
        return 32 - this.networkBitCount;
    }

    @Override
    public IPv4Address getNetworkAddress() {
        return this.getFirst();
    }

    protected static enum IPv4SubnetMask {
        MASK_00,
        MASK_01,
        MASK_02,
        MASK_03,
        MASK_04,
        MASK_05,
        MASK_06,
        MASK_07,
        MASK_08,
        MASK_09,
        MASK_10,
        MASK_11,
        MASK_12,
        MASK_13,
        MASK_14,
        MASK_15,
        MASK_16,
        MASK_17,
        MASK_18,
        MASK_19,
        MASK_20,
        MASK_21,
        MASK_22,
        MASK_23,
        MASK_24,
        MASK_25,
        MASK_26,
        MASK_27,
        MASK_28,
        MASK_29,
        MASK_30,
        MASK_31,
        MASK_32;

        private final int mask;
        private final byte bitCount = (byte)this.ordinal();

        public static IPv4SubnetMask fromMaskLen(byte maskLen) {
            if (maskLen >= 0 && maskLen <= 32) {
                return IPv4SubnetMask.values()[maskLen];
            }
            throw new IllegalArgumentException("The mask length must be between 0 and 32");
        }

        private IPv4SubnetMask() {
            this.mask = this.bitCount != 0 ? -1 << 32 - this.bitCount : 0;
        }

        public int mask() {
            return this.mask;
        }

        public byte maskBitCount() {
            return this.bitCount;
        }

        public int and(int ip) {
            return this.mask & ip;
        }

        public IPv4Address and(IPv4Address ip) {
            return IPv4Address.of(this.and(ip.toInt()));
        }

        public int orInverted(int ip) {
            return ~this.mask | ip;
        }

        public IPv4Address orInverted(IPv4Address ip) {
            return IPv4Address.of(this.orInverted(ip.toInt()));
        }

        public IPv4Address toAddress() {
            return IPv4Address.of(this.mask());
        }
    }
}

