/*
 * Decompiled with CFR 0.152.
 */
package com.github.maltalex.ineter.range;

import com.github.maltalex.ineter.base.IPv6Address;
import com.github.maltalex.ineter.range.IPRange;
import com.github.maltalex.ineter.range.IPv6Subnet;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;

public class IPv6Range
extends IPRange<IPv6Address> {
    private static final long serialVersionUID = 1L;
    final IPv6Address firstAddress;
    final IPv6Address lastAddress;

    public static IPv6Range of(IPv6Address firstAddress, IPv6Address lastAddress) {
        return new IPv6Range(firstAddress, lastAddress);
    }

    public static IPv6Range of(IPv6Address address) {
        return IPv6Range.of(address, address);
    }

    public static IPv6Range of(String firstAddress, String lastAddress) {
        return new IPv6Range(IPv6Address.of(firstAddress), IPv6Address.of(lastAddress));
    }

    public static IPv6Range of(String address) {
        return IPv6Range.of(address, address);
    }

    public static IPv6Range of(byte[] firstAddress, byte[] lastAddress) {
        return new IPv6Range(IPv6Address.of(firstAddress), IPv6Address.of(lastAddress));
    }

    public static IPv6Range of(byte[] address) {
        return IPv6Range.of(address, address);
    }

    public static IPv6Range of(Inet6Address firstAddress, Inet6Address lastAddress) {
        return new IPv6Range(IPv6Address.of(firstAddress), IPv6Address.of(lastAddress));
    }

    public static IPv6Range of(Inet6Address address) {
        return IPv6Range.of(address, address);
    }

    @Deprecated
    public static IPv6Range between(String between) {
        String[] parts = between.split("-");
        return IPv6Range.of(IPv6Address.of(parts[0].trim()), IPv6Address.of(parts[1].trim()));
    }

    public static IPv6Range parse(String from) {
        return IPv6Range.parseRange(from, IPv6Range::of, IPv6Subnet::of);
    }

    public IPv6Range(IPv6Address firstAddress, IPv6Address lastAddress) {
        this.firstAddress = firstAddress;
        this.lastAddress = lastAddress;
        if (this.firstAddress == null || this.lastAddress == null) {
            throw new NullPointerException("Neither the first nor the last address can be null");
        }
        if (this.firstAddress.compareTo(lastAddress) > 0) {
            throw new IllegalArgumentException(String.format("The first address in the range (%s) has to be lower than the last address (%s)", firstAddress.toString(), lastAddress.toString()));
        }
    }

    @Override
    public IPv6Address getFirst() {
        return this.firstAddress;
    }

    @Override
    public IPv6Address getLast() {
        return this.lastAddress;
    }

    @Override
    public BigInteger length() {
        return this.lastAddress.toBigInteger().subtract(this.firstAddress.toBigInteger()).add(BigInteger.ONE);
    }

    @Override
    public Iterator<IPv6Address> iterator(final boolean skipFirst, final boolean skipLast) {
        return new Iterator<IPv6Address>(){
            AtomicLong nextAddition;
            long totalCount;
            {
                this.nextAddition = new AtomicLong(skipFirst ? 1L : 0L);
                this.totalCount = skipLast ? IPv6Range.this.length().longValueExact() - 1L : IPv6Range.this.length().longValueExact();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.nextAddition.get() < this.totalCount;
            }

            @Override
            public IPv6Address next() {
                long tempNext = this.nextAddition.getAndIncrement();
                if (tempNext < this.totalCount) {
                    return IPv6Range.this.firstAddress.plus(tempNext);
                }
                throw new NoSuchElementException();
            }
        };
    }

    protected int numberOfTrailingOnes(IPv6Address a) {
        long notLower = a.getLower() ^ 0xFFFFFFFFFFFFFFFFL;
        return notLower == 0L ? 64 + Long.numberOfTrailingZeros(a.getUpper() ^ 0xFFFFFFFFFFFFFFFFL) : Long.numberOfTrailingZeros(notLower);
    }

    protected int numberOfTrailingZeros(IPv6Address a) {
        return a.getLower() == 0L ? 64 + Long.numberOfTrailingZeros(a.getUpper()) : Long.numberOfTrailingZeros(a.getLower());
    }

    protected int numberOfLeadingEq(IPv6Address a, IPv6Address b) {
        long upperXOR = a.getUpper() ^ b.getUpper();
        if (upperXOR == 0L) {
            return 64 + Long.numberOfLeadingZeros(a.getLower() ^ b.getLower());
        }
        return Long.numberOfLeadingZeros(upperXOR);
    }

    protected IPv6Subnet maxSubnetInRange(IPv6Address addr) {
        int addrHostBits = this.numberOfTrailingZeros(addr);
        int networkBitsEq = this.numberOfLeadingEq(this.lastAddress, addr);
        int hostBitsMax = 128 - networkBitsEq;
        if (this.numberOfTrailingOnes(this.lastAddress) < hostBitsMax) {
            --hostBitsMax;
        }
        int hostBits = Math.min(addrHostBits, hostBitsMax);
        return IPv6Subnet.of(addr, 128 - hostBits);
    }

    @Override
    public List<IPv6Subnet> toSubnets() {
        IPv6Subnet nextSubnet;
        ArrayList<IPv6Subnet> result = new ArrayList<IPv6Subnet>();
        IPv6Address lastAddress = this.firstAddress.previous();
        do {
            nextSubnet = this.maxSubnetInRange(lastAddress.next());
            result.add(nextSubnet);
        } while ((lastAddress = nextSubnet.lastAddress).compareTo(this.lastAddress) < 0);
        return result;
    }
}

