/*
 * Decompiled with CFR 0.152.
 */
package com.github.maltalex.ineter.base;

import com.github.maltalex.ineter.base.IPv6Address;
import java.net.Inet6Address;
import java.util.Objects;

public class ZonedIPv6Address
extends IPv6Address {
    private static final long serialVersionUID = 1L;
    protected final String zone;

    public static ZonedIPv6Address of(String address) {
        IPv6Address ip = IPv6Address.of(address);
        if (!(ip instanceof ZonedIPv6Address)) {
            throw new IllegalArgumentException(String.format("The provided address (%s) is not zoned", address));
        }
        return (ZonedIPv6Address)ip;
    }

    public static ZonedIPv6Address of(long upper, long lower, String zone) {
        return new ZonedIPv6Address(upper, lower, zone);
    }

    public static ZonedIPv6Address of(byte[] bigEndianByteArr, String zone) {
        ZonedIPv6Address.verifyArray(bigEndianByteArr);
        long upper = IPv6Address.LongByte.extractLong(bigEndianByteArr, 0);
        long lower = IPv6Address.LongByte.extractLong(bigEndianByteArr, 8);
        return new ZonedIPv6Address(upper, lower, zone);
    }

    public static ZonedIPv6Address of(IPv6Address address, String zone) {
        return ZonedIPv6Address.of(address.upper, address.lower, zone);
    }

    public static ZonedIPv6Address of(Inet6Address address) {
        if (address.getScopedInterface() != null) {
            return ZonedIPv6Address.of(address.getAddress(), address.getScopedInterface().getName());
        }
        return ZonedIPv6Address.of(address.getAddress(), Integer.toString(address.getScopeId()));
    }

    public ZonedIPv6Address(long upper, long lower, String zone) {
        super(upper, lower);
        this.zone = zone;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this.zone == null ? 0 : this.zone.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.zone, ((ZonedIPv6Address)obj).zone);
    }

    @Override
    public int compareTo(IPv6Address o) {
        if (o == null) {
            return 1;
        }
        if (o.isZoned()) {
            int zoneCompare = this.zone.compareTo(((ZonedIPv6Address)o).zone);
            return zoneCompare == 0 ? super.longCompare(o) : zoneCompare;
        }
        return 1;
    }

    @Override
    public String toString() {
        return String.format("%s%%%s", super.toString(), this.zone);
    }

    @Override
    public ZonedIPv6Address next() {
        return this.plus(1);
    }

    @Override
    public ZonedIPv6Address plus(long n) {
        if (n < 0L) {
            return this.minus(-n);
        }
        long newLower = this.lower + n;
        long newUpper = this.upper;
        if (ZonedIPv6Address.hasCarry(this.lower, n, newLower)) {
            ++newUpper;
        }
        return new ZonedIPv6Address(newUpper, newLower, this.zone);
    }

    @Override
    public ZonedIPv6Address plus(int n) {
        return this.plus((long)n);
    }

    @Override
    public ZonedIPv6Address previous() {
        return this.minus(1);
    }

    @Override
    public ZonedIPv6Address minus(int n) {
        return this.minus((long)n);
    }

    @Override
    public ZonedIPv6Address minus(long n) {
        if (n < 0L) {
            return this.plus(-n);
        }
        long newLower = this.lower - n;
        long newUpper = this.upper;
        if (ZonedIPv6Address.hasBorrow(this.lower, n, newLower)) {
            --newUpper;
        }
        return new ZonedIPv6Address(newUpper, newLower, this.zone);
    }

    @Override
    public boolean isZoned() {
        return true;
    }

    public String getZone() {
        return this.zone;
    }
}

