/*
 * Decompiled with CFR 0.152.
 */
package com.github.maltalex.ineter.range;

import com.github.maltalex.ineter.base.IPAddress;
import com.github.maltalex.ineter.range.IPSubnet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class IPRange<T extends IPAddress>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;

    protected static <T> T parseRange(String from, BiFunction<String, String, ? extends T> rangeProducer, Function<String, ? extends T> subnetProducer) {
        String[] parts = from.split("-");
        if (parts.length == 2) {
            return rangeProducer.apply(parts[0].trim(), parts[1].trim());
        }
        if (parts.length == 1) {
            if (from.contains("/")) {
                return subnetProducer.apply(from);
            }
            return rangeProducer.apply(parts[0].trim(), parts[0].trim());
        }
        throw new IllegalArgumentException(String.format("Inappropriate format for address range string %s.", from));
    }

    protected static <T> T parseSubnet(String from, BiFunction<String, Integer, ? extends T> subnetProducer, int singleAddressMask) {
        String[] parts = from.split("/");
        if (parts.length == 2) {
            return subnetProducer.apply(parts[0].trim(), Integer.parseInt(parts[1].trim()));
        }
        if (parts.length == 1) {
            return subnetProducer.apply(parts[0].trim(), singleAddressMask);
        }
        throw new IllegalArgumentException(String.format("Inappropriate format for address subnet string %s.", from));
    }

    public abstract T getFirst();

    public abstract T getLast();

    public boolean overlaps(IPRange<T> range) {
        return this.contains(range.getFirst()) || this.contains(range.getLast()) || range.contains(this.getFirst());
    }

    public boolean contains(T ip) {
        return ((Comparable)this.getFirst()).compareTo(ip) <= 0 && ((Comparable)this.getLast()).compareTo(ip) >= 0;
    }

    public boolean contains(IPRange<T> range) {
        return this.contains(range.getFirst()) && this.contains(range.getLast());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.getFirst().hashCode();
        result = prime * result + this.getLast().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IPRange)) {
            return false;
        }
        IPRange other = (IPRange)obj;
        return this.getFirst().equals(other.getFirst()) && this.getLast().equals(other.getLast());
    }

    public String toString() {
        return String.format("%s - %s", this.getFirst().toString(), this.getLast().toString());
    }

    public abstract Number length();

    @Override
    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    public Iterator<T> iterator(boolean trim) {
        return this.iterator(trim, trim);
    }

    public abstract Iterator<T> iterator(boolean var1, boolean var2);

    public abstract List<? extends IPSubnet<? extends T>> toSubnets();
}

