/*
 * Decompiled with CFR 0.152.
 */
package com.github.manikmagar.maven.versioner;

import java.util.Objects;

public class Version {
    private int major;
    private int minor;
    private int patch;
    private int commit;
    private final String branch;
    private final String hash;

    public Version(String branch, String hash) {
        this(branch, hash, 0, 0, 0);
        this.commit = 0;
    }

    public Version(String branch, String hash, int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.branch = branch;
        this.hash = hash;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getCommit() {
        return this.commit;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getHash() {
        return this.hash;
    }

    public void incrementMajor() {
        ++this.major;
        this.minor = 0;
        this.patch = 0;
        this.commit = 0;
    }

    public void incrementMinor() {
        ++this.minor;
        this.patch = 0;
        this.commit = 0;
    }

    public void incrementPatch() {
        ++this.patch;
        this.commit = 0;
    }

    public void incrementCommit() {
        ++this.commit;
    }

    public String toSemver() {
        return String.format("%d.%d.%d", this.getMajor(), this.getMinor(), this.getPatch());
    }

    public String toString() {
        return String.format("%s [branch: %s, version: %s, hash: %s]", this.getClass().getName(), this.branch, this.toSemver(), this.hash);
    }

    public void printVersion() {
        System.out.printf(this.toString(), new Object[0]);
        System.out.println();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.getMajor() == version.getMajor() && this.getMinor() == version.getMinor() && this.getPatch() == version.getPatch();
    }

    public int hashCode() {
        return Objects.hash(this.getMajor(), this.getMinor(), this.getPatch());
    }
}

