/*
 * Decompiled with CFR 0.152.
 */
package com.github.manikmagar.maven.versioner.git;

import com.github.manikmagar.maven.versioner.Version;
import com.github.manikmagar.maven.versioner.Versioner;
import com.github.manikmagar.maven.versioner.git.JGit;
import com.github.manikmagar.maven.versioner.mojo.params.VersionConfig;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;

public class JGitVersioner
implements Versioner {
    VersionConfig versionConfig;

    public JGitVersioner(VersionConfig versionConfig) {
        this.versionConfig = versionConfig;
    }

    @Override
    public Version version() {
        return JGit.executeOperation(git -> {
            String branch = git.getRepository().getBranch();
            Ref head = git.getRepository().findRef("HEAD");
            String hash = "";
            if (head != null && head.getObjectId() != null) {
                hash = head.getObjectId().getName();
            }
            Version version = new Version(branch, hash, this.versionConfig.getInitial().getMajor(), this.versionConfig.getInitial().getMinor(), this.versionConfig.getInitial().getPatch());
            Iterable commits = git.log().call();
            List revCommits = StreamSupport.stream(commits.spliterator(), false).collect(Collectors.toList());
            Collections.reverse(revCommits);
            for (RevCommit commit : revCommits) {
                if (commit.getFullMessage().contains(this.versionConfig.getKeywords().getMajorKey())) {
                    version.incrementMajor();
                    continue;
                }
                if (commit.getFullMessage().contains(this.versionConfig.getKeywords().getMinorKey())) {
                    version.incrementMinor();
                    continue;
                }
                if (commit.getFullMessage().contains(this.versionConfig.getKeywords().getPatchKey())) {
                    version.incrementPatch();
                    continue;
                }
                version.incrementCommit();
            }
            return version;
        });
    }
}

