/*
 * Decompiled with CFR 0.152.
 */
package com.github.manikmagar.maven.versioner.mojo;

import com.github.manikmagar.maven.versioner.GitVersionerException;
import com.github.manikmagar.maven.versioner.Version;
import com.github.manikmagar.maven.versioner.git.GitTag;
import com.github.manikmagar.maven.versioner.mojo.AbstractVersionerMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="tag", requiresProject=true)
public class Tag
extends AbstractVersionerMojo {
    @Parameter(name="failWhenTagExist", defaultValue="true", property="tag.failWhenTagExist")
    private boolean failWhenTagExist = true;
    @Parameter(name="tagMessagePattern", defaultValue="Release version %v", property="tag.messagePattern")
    private String tagMessagePattern = "Release version %v";
    @Parameter(name="tagNamePattern", defaultValue="v%v", property="tag.namePattern")
    private String tagNamePattern = "v%v";

    public boolean isFailWhenTagExist() {
        return this.failWhenTagExist;
    }

    public String getTagMessagePattern() {
        return this.tagMessagePattern;
    }

    public String getTagNamePattern() {
        return this.tagNamePattern;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Version version = this.getVersioner().version();
        String tagName = this.replaceTokens(this.getTagNamePattern(), version);
        String tagMessage = this.replaceTokens(this.getTagMessagePattern(), version);
        this.getLog().info((CharSequence)("Current version: " + version.toString()));
        this.getLog().info((CharSequence)String.format("Tag version '%s' with message '%s'", tagName, tagMessage));
        if (GitTag.exists(tagName)) {
            this.getLog().error((CharSequence)String.format("Tag already exist: %s", tagName));
            if (this.isFailWhenTagExist()) {
                throw new GitVersionerException("Tag already exist: " + tagName);
            }
        } else {
            String tagId = GitTag.create(tagName, tagMessage);
            this.getLog().info((CharSequence)String.format("Created tag: '%s'", tagId));
        }
    }
}

