/*
 * Decompiled with CFR 0.152.
 */
package com.github.manikmagar.semver4j;

import com.github.manikmagar.semver4j.internal.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SemVer {
    private final AtomicInteger major;
    private final AtomicInteger minor;
    private final AtomicInteger patch;
    private List<Prerelease> prereleases = Collections.synchronizedList(new ArrayList());
    private List<BuildMetadata> buildMetadata = Collections.synchronizedList(new ArrayList());
    public static final SemVer ZERO = new SemVer(0, 0, 0);

    public SemVer(int major, int minor, int patch) {
        Util.mustBePositive(major);
        Util.mustBePositive(minor);
        Util.mustBePositive(patch);
        this.major = new AtomicInteger(major);
        this.minor = new AtomicInteger(minor);
        this.patch = new AtomicInteger(patch);
    }

    public SemVer() {
        this(0, 0, 0);
    }

    public int getMajor() {
        return this.major.get();
    }

    public int getMinor() {
        return this.minor.get();
    }

    public int getPatch() {
        return this.patch.get();
    }

    public void validate() {
        Util.mustBePositive(this.getMajor());
        Util.mustBePositive(this.getMinor());
        Util.mustBePositive(this.getPatch());
    }

    public static SemVer of(int major, int minor, int patch) {
        return new SemVer(major, minor, patch);
    }

    public static SemVer zero() {
        return new SemVer(0, 0, 0);
    }

    public SemVer with(Prerelease prerelease) {
        this.prereleases.add(prerelease);
        return this;
    }

    public SemVer withNew(Prerelease prerelease) {
        this.resetPrereleasesIfNeeded();
        this.prereleases.add(prerelease);
        return this;
    }

    public static Prerelease prerelease(String identifier) {
        return Prerelease.of(identifier);
    }

    public static BuildMetadata build(String identifier) {
        return BuildMetadata.of(identifier);
    }

    public SemVer with(BuildMetadata buildMetadata) {
        this.buildMetadata.add(buildMetadata);
        return this;
    }

    public SemVer withNew(BuildMetadata buildMetadata) {
        this.resetBuildMetadataIfNeeded();
        this.buildMetadata.add(buildMetadata);
        return this;
    }

    public SemVer incrementMajor() {
        this.major.incrementAndGet();
        this.minor.set(0);
        this.patch.set(0);
        this.resetMetadata();
        return this;
    }

    public SemVer incrementMinor() {
        this.minor.incrementAndGet();
        this.patch.set(0);
        this.resetMetadata();
        return this;
    }

    public SemVer incrementPatch() {
        this.patch.incrementAndGet();
        this.resetMetadata();
        return this;
    }

    private void resetMetadata() {
        this.resetPrereleasesIfNeeded();
        this.resetBuildMetadataIfNeeded();
    }

    private void resetPrereleasesIfNeeded() {
        if (!this.prereleases.isEmpty()) {
            this.prereleases = Collections.synchronizedList(new ArrayList());
        }
    }

    private void resetBuildMetadataIfNeeded() {
        if (!this.buildMetadata.isEmpty()) {
            this.buildMetadata = Collections.synchronizedList(new ArrayList());
        }
    }

    public boolean isInitialDevelopment() {
        return this.getMajor() == 0;
    }

    public boolean isPrerelease() {
        return !this.prereleases.isEmpty();
    }

    public String toString() {
        String buildIdentifier;
        String version = String.format("%d.%d.%d", this.getMajor(), this.getMinor(), this.getPatch());
        String releaseIdentifier = this.prereleases.stream().map(Identifier::getLabel).collect(Collectors.joining("."));
        if (Util.isNotEmpty(releaseIdentifier)) {
            version = version + "-" + releaseIdentifier;
        }
        if (Util.isNotEmpty(buildIdentifier = this.buildMetadata.stream().map(Identifier::getLabel).collect(Collectors.joining(".")))) {
            version = version + "+" + buildIdentifier;
        }
        return version;
    }

    public static class BuildMetadata
    extends Identifier {
        private BuildMetadata(String label) {
            super(label);
        }

        public static BuildMetadata of(String label) {
            return new BuildMetadata(BuildMetadata.validated(label));
        }
    }

    public static class Prerelease
    extends Identifier {
        private Prerelease(String label) {
            super(label);
        }

        public static Prerelease of(String label) {
            return new Prerelease(Prerelease.validated(label));
        }

        public static String validated(String label) {
            Identifier.validated(label);
            if (NUMERIC_VALUE.matcher(label).matches() && label.startsWith("0")) {
                throw new IllegalArgumentException(String.format("Leading zeros are not allowed for numerical identifier '%s'", label));
            }
            return label;
        }
    }

    public static class Identifier {
        static Pattern PATTERN = Pattern.compile("^[0-9A-Za-z-]*$");
        static Pattern NUMERIC_VALUE = Pattern.compile("^[0-9]*$");
        private final String label;

        private Identifier(String label) {
            this.label = label;
        }

        public static Identifier of(String label) {
            return new Identifier(Identifier.validated(label));
        }

        public static String validated(String label) {
            Objects.requireNonNull(label, "Identifier must not be null");
            if (!PATTERN.matcher(label).matches()) {
                throw new IllegalArgumentException(String.format("Identifier '%s' does not match with pattern '%s'", label, PATTERN.pattern()));
            }
            return label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

