/*
 * Decompiled with CFR 0.152.
 */
package com.github.marcoferrer.krotoplus.generators;

import com.github.marcoferrer.krotoplus.config.FileFilter;
import com.github.marcoferrer.krotoplus.config.GrpcStubExtsGenOptions;
import com.github.marcoferrer.krotoplus.generators.Generator;
import com.github.marcoferrer.krotoplus.generators.GeneratorContext;
import com.github.marcoferrer.krotoplus.proto.ProtoFile;
import com.github.marcoferrer.krotoplus.proto.ProtoMethod;
import com.github.marcoferrer.krotoplus.proto.ProtoService;
import com.github.marcoferrer.krotoplus.utils.CommonClassNames;
import com.github.marcoferrer.krotoplus.utils.FileFilterExtsKt;
import com.google.protobuf.compiler.PluginProtos;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\t\u0010\u0016\u001a\u00020\u0017H\u0096\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\tH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u001a"}, d2={"Lcom/github/marcoferrer/krotoplus/generators/GrpcStubExtsGenerator;", "Lcom/github/marcoferrer/krotoplus/generators/Generator;", "()V", "isEnabled", "", "()Z", "buildBidiStreamingOverloads", "", "method", "Lcom/github/marcoferrer/krotoplus/proto/ProtoMethod;", "fileSpecBuilder", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "buildFileSpec", "Lcom/google/protobuf/compiler/PluginProtos$CodeGeneratorResponse$File;", "service", "Lcom/github/marcoferrer/krotoplus/proto/ProtoService;", "options", "Lcom/github/marcoferrer/krotoplus/config/GrpcStubExtsGenOptions;", "buildFunSpecs", "buildServerStreamingOverloads", "buildSuspendingUnaryOverloads", "buildUnaryOverloads", "invoke", "Lcom/google/protobuf/compiler/PluginProtos$CodeGeneratorResponse;", "requestValueCodeBlock", "Lcom/squareup/kotlinpoet/CodeBlock;", "protoc-gen-kroto-plus"})
public final class GrpcStubExtsGenerator
implements Generator {
    public static final GrpcStubExtsGenerator INSTANCE;

    @Override
    public boolean isEnabled() {
        return this.getContext().getConfig().getGrpcStubExtsCount() > 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PluginProtos.CodeGeneratorResponse invoke() {
        PluginProtos.CodeGeneratorResponse.Builder responseBuilder = PluginProtos.CodeGeneratorResponse.newBuilder();
        for (ProtoService service : this.getContext().getSchema().getProtoServices()) {
            Iterator<GrpcStubExtsGenOptions> iterator = this.getContext().getConfig().getGrpcStubExtsList().iterator();
            while (iterator.hasNext()) {
                String string;
                FileFilter fileFilter;
                void this_$iv;
                GrpcStubExtsGenOptions options2;
                GrpcStubExtsGenOptions grpcStubExtsGenOptions = options2 = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)grpcStubExtsGenOptions, (String)"options");
                Intrinsics.checkExpressionValueIsNotNull((Object)grpcStubExtsGenOptions.getFilter(), (String)"options.filter");
                ProtoFile protoFile = service.getProtoFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)this_$iv.getDescriptorProto().getName(), (String)"descriptorProto.name");
                if (!FileFilterExtsKt.matches(fileFilter, string)) continue;
                PluginProtos.CodeGeneratorResponse.File file = this.buildFileSpec(service, options2);
                if (file == null) continue;
                ProtoFile it = protoFile = file;
                responseBuilder.addFile((PluginProtos.CodeGeneratorResponse.File)it);
            }
        }
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = responseBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeGeneratorResponse, (String)"responseBuilder.build()");
        return codeGeneratorResponse;
    }

    private final PluginProtos.CodeGeneratorResponse.File buildFileSpec(ProtoService service, GrpcStubExtsGenOptions options2) {
        String filename = service.getName() + "RpcOverloads";
        FileSpec.Builder fileSpecBuilder = FileSpec.Companion.builder(service.getProtoFile().getJavaPackage(), filename).addComment("THIS IS AN AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.", new Object[0]).addAnnotation(AnnotationSpec.Companion.builder(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(JvmName.class))).useSiteTarget(AnnotationSpec.UseSiteTarget.FILE).addMember("%S", new Object[]{'-' + filename}).build());
        for (ProtoMethod method : service.getMethodDefinitions()) {
            this.buildFunSpecs(method, options2, fileSpecBuilder);
        }
        FileSpec fileSpec = fileSpecBuilder.build();
        FileSpec it = fileSpec;
        Collection collection = it.getMembers();
        Object object = !collection.isEmpty() ? fileSpec : null;
        return object != null ? this.toResponseFileProto((FileSpec)object) : null;
    }

    private final void buildFunSpecs(ProtoMethod method, GrpcStubExtsGenOptions options2, FileSpec.Builder fileSpecBuilder) {
        if (method.isUnary()) {
            this.buildUnaryOverloads(method, options2, fileSpecBuilder);
        } else if (options2.getSupportCoroutines() && method.isServerStream()) {
            this.buildServerStreamingOverloads(method, fileSpecBuilder);
        } else if (options2.getSupportCoroutines() && (method.isBidi() || method.isClientStream())) {
            this.buildBidiStreamingOverloads(method, fileSpecBuilder);
        }
    }

    private final void buildUnaryOverloads(ProtoMethod method, GrpcStubExtsGenOptions options2, FileSpec.Builder fileSpecBuilder) {
        FunSpec.Builder builder;
        FunSpec.Builder funSpecBuilder = FunSpec.Companion.builder(method.getFunctionName());
        if (method.isNotEmptyInput()) {
            funSpecBuilder.addModifiers(new KModifier[]{KModifier.INLINE}).addParameter("block", (TypeName)LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, (TypeName)((TypeName)method.getRequestClassName().nestedClass("Builder")), null, (TypeName)((TypeName)TypeNames.UNIT), (int)2, null), new KModifier[0]);
        }
        FunSpec.Builder it = builder = funSpecBuilder.receiver((TypeName)method.getProtoService().getFutureStubClassName()).addCode(this.requestValueCodeBlock(method)).addStatement("return %N(request)", new Object[]{method.getFunctionName()}).returns((TypeName)ParameterizedTypeName.Companion.get(new ClassName("com.google.common.util.concurrent", "ListenableFuture", new String[0]), new TypeName[]{(TypeName)method.getResponseClassName()}));
        fileSpecBuilder.addFunction(it.build());
        it = builder = funSpecBuilder.receiver((TypeName)method.getProtoService().getBlockingStubClassName()).returns((TypeName)method.getResponseClassName());
        fileSpecBuilder.addFunction(it.build());
        if (options2.getSupportCoroutines()) {
            this.buildSuspendingUnaryOverloads(method, fileSpecBuilder);
        }
    }

    private final void buildSuspendingUnaryOverloads(ProtoMethod method, FileSpec.Builder fileSpecBuilder) {
        FunSpec.Builder builder;
        fileSpecBuilder.addStaticImport("com.github.marcoferrer.krotoplus.coroutines", new String[]{"suspendingUnaryCallObserver"});
        FunSpec.Builder $receiver = builder = FunSpec.Companion.builder(method.getFunctionName()).addModifiers(new KModifier[]{KModifier.SUSPEND}).receiver((TypeName)method.getProtoService().getAsyncStubClassName());
        if (method.isNotEmptyInput()) {
            $receiver.addParameter("request", (TypeName)method.getRequestClassName(), new KModifier[0]);
        } else {
            $receiver.addCode(INSTANCE.requestValueCodeBlock(method));
        }
        FunSpec.Builder it = builder = builder.returns((TypeName)method.getResponseClassName()).addStatement("return suspendingUnaryCallObserver{ observer -> %N(request,observer) }", new Object[]{method.getFunctionName()});
        fileSpecBuilder.addFunction(it.build());
        if (method.isNotEmptyInput()) {
            $receiver = builder = FunSpec.Companion.builder(method.getFunctionName()).addModifiers(new KModifier[]{KModifier.SUSPEND}).receiver((TypeName)method.getProtoService().getAsyncStubClassName());
            if (method.isNotEmptyInput()) {
                $receiver.addModifiers(new KModifier[]{KModifier.INLINE});
                $receiver.addParameter("block", (TypeName)LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, (TypeName)((TypeName)method.getRequestClassName().nestedClass("Builder")), null, (TypeName)((TypeName)TypeNames.UNIT), (int)2, null), new KModifier[0]);
            }
            it = builder = builder.returns((TypeName)method.getResponseClassName()).addCode(this.requestValueCodeBlock(method)).addStatement("return %N(request)", new Object[]{method.getFunctionName()});
            fileSpecBuilder.addFunction(it.build());
        }
    }

    private final void buildServerStreamingOverloads(ProtoMethod method, FileSpec.Builder fileSpecBuilder) {
        FunSpec.Builder builder;
        ClassName inboundChannelClassName = new ClassName("com.github.marcoferrer.krotoplus.coroutines", "InboundStreamChannel", new String[0]);
        ParameterizedTypeName returnType = ParameterizedTypeName.Companion.get(inboundChannelClassName, new TypeName[]{(TypeName)method.getResponseClassName()});
        FunSpec.Builder $receiver = builder = FunSpec.Companion.builder(method.getFunctionName()).receiver((TypeName)method.getProtoService().getAsyncStubClassName());
        if (method.isNotEmptyInput()) {
            $receiver.addParameter("request", (TypeName)method.getRequestClassName(), new KModifier[0]);
        } else {
            $receiver.addCode(INSTANCE.requestValueCodeBlock(method));
        }
        FunSpec.Builder it = builder = builder.returns((TypeName)returnType).addStatement("return %T().also { observer -> %N(request,observer) }", new Object[]{returnType, method.getFunctionName()});
        fileSpecBuilder.addFunction(it.build());
    }

    private final void buildBidiStreamingOverloads(ProtoMethod method, FileSpec.Builder fileSpecBuilder) {
        FunSpec.Builder builder;
        fileSpecBuilder.addStaticImport("com.github.marcoferrer.krotoplus.coroutines", new String[]{"bidiCallChannel"});
        FunSpec.Builder it = builder = FunSpec.Companion.builder(method.getFunctionName()).receiver((TypeName)method.getProtoService().getAsyncStubClassName()).addAnnotation(CommonClassNames.INSTANCE.getObsoleteCoroutinesApi()).addAnnotation(CommonClassNames.INSTANCE.getExperimentalCoroutinesApi()).addAnnotation(new ClassName("com.github.marcoferrer.krotoplus.coroutines", "ExperimentalKrotoPlusCoroutinesApi", new String[0])).returns((TypeName)ParameterizedTypeName.Companion.get(new ClassName("com.github.marcoferrer.krotoplus.coroutines", "ClientBidiCallChannel", new String[0]), new TypeName[]{(TypeName)method.getRequestClassName(), (TypeName)method.getResponseClassName()})).addStatement("return bidiCallChannel{ responseObserver -> %N(responseObserver) }", new Object[]{method.getFunctionName()});
        fileSpecBuilder.addFunction(it.build());
    }

    private final CodeBlock requestValueCodeBlock(@NotNull ProtoMethod $receiver) {
        String requestValueTemplate = $receiver.isEmptyInput() ? "val request = %T.getDefaultInstance()\n" : "val request = %T.newBuilder().apply(block).build()\n";
        return CodeBlock.Companion.of(requestValueTemplate, new Object[]{$receiver.getRequestClassName()});
    }

    private GrpcStubExtsGenerator() {
    }

    static {
        GrpcStubExtsGenerator grpcStubExtsGenerator;
        INSTANCE = grpcStubExtsGenerator = new GrpcStubExtsGenerator();
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return Generator.DefaultImpls.getContext(this);
    }

    @Override
    @NotNull
    public PluginProtos.CodeGeneratorResponse.File toResponseFileProto(@NotNull FileSpec $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Generator.DefaultImpls.toResponseFileProto(this, $receiver);
    }
}

