/*
 * Decompiled with CFR 0.152.
 */
package com.github.marcoferrer.krotoplus.generators;

import com.github.marcoferrer.krotoplus.config.FileFilter;
import com.github.marcoferrer.krotoplus.config.GrpcCoroutinesGenOptions;
import com.github.marcoferrer.krotoplus.generators.Generator;
import com.github.marcoferrer.krotoplus.generators.GeneratorContext;
import com.github.marcoferrer.krotoplus.generators.GrpcCoroutinesGenerator;
import com.github.marcoferrer.krotoplus.generators.GrpcCoroutinesGenerator$WhenMappings;
import com.github.marcoferrer.krotoplus.proto.ProtoFile;
import com.github.marcoferrer.krotoplus.proto.ProtoFileKt;
import com.github.marcoferrer.krotoplus.proto.ProtoMessage;
import com.github.marcoferrer.krotoplus.proto.ProtoMethod;
import com.github.marcoferrer.krotoplus.proto.ProtoService;
import com.github.marcoferrer.krotoplus.proto.ProtoType;
import com.github.marcoferrer.krotoplus.utils.CodeBuilderExtsKt;
import com.github.marcoferrer.krotoplus.utils.CommonClassNames;
import com.github.marcoferrer.krotoplus.utils.FileFilterExtsKt;
import com.google.protobuf.compiler.PluginProtos;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0018\u001a\u00020\u0019H\u0096\u0002J\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\tH\u0002J\u0012\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\tH\u0002J\f\u0010\u001e\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010 \u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010!\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010\"\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010#\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010$\u001a\u00020%*\u00020\tH\u0002J\f\u0010&\u001a\u00020%*\u00020\tH\u0002J\u0012\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\tH\u0002J\u0012\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\tH\u0002J\u000e\u0010)\u001a\u0004\u0018\u00010**\u00020\tH\u0002J\f\u0010+\u001a\u00020\u001c*\u00020\tH\u0002J\f\u0010,\u001a\u00020%*\u00020\tH\u0002J\u0012\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\tH\u0002J\f\u0010.\u001a\u00020/*\u00020\u001fH\u0002J\u0018\u00100\u001a\b\u0012\u0004\u0012\u00020*0\u001b*\b\u0012\u0004\u0012\u0002010\u001bH\u0002J\u0016\u00102\u001a\u00020\u001c*\u0002012\b\b\u0002\u00103\u001a\u00020\u0007H\u0002J\u0010\u00104\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\tJ\f\u00105\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u00106\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u00107\u001a\u00020%*\u00020\tH\u0002J\f\u00108\u001a\u00020%*\u00020\tH\u0002J\f\u00109\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010:\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010;\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010<\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010=\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010>\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010?\u001a\u00020\u001c*\u00020\u001fH\u0002J\f\u0010@\u001a\u00020\u001c*\u00020\u001fH\u0002J\u0012\u0010A\u001a\b\u0012\u0004\u0012\u0002010\u001b*\u00020\tH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\u0007*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\u0007*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u000f*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0018\u0010\u0014\u001a\u00020\u000f*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0018\u0010\u0016\u001a\u00020\u0007*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006B"}, d2={"Lcom/github/marcoferrer/krotoplus/generators/GrpcCoroutinesGenerator;", "Lcom/github/marcoferrer/krotoplus/generators/Generator;", "()V", "isEnabled", "", "()Z", "serviceDelegateName", "", "baseImplName", "Lcom/github/marcoferrer/krotoplus/proto/ProtoService;", "getBaseImplName", "(Lcom/github/marcoferrer/krotoplus/proto/ProtoService;)Ljava/lang/String;", "outerObjectName", "getOuterObjectName", "serviceDelegateClassName", "Lcom/squareup/kotlinpoet/ClassName;", "getServiceDelegateClassName", "(Lcom/github/marcoferrer/krotoplus/proto/ProtoService;)Lcom/squareup/kotlinpoet/ClassName;", "serviceJavaBaseImplClassName", "getServiceJavaBaseImplClassName", "stubClassName", "getStubClassName", "stubName", "getStubName", "invoke", "Lcom/google/protobuf/compiler/PluginProtos$CodeGeneratorResponse;", "buildBaseImplRpcMethodDelegates", "", "Lcom/squareup/kotlinpoet/FunSpec;", "buildBaseImplRpcMethods", "buildBidiBaseImpl", "Lcom/github/marcoferrer/krotoplus/proto/ProtoMethod;", "buildBidiMethodBaseImplDelegate", "buildChannelLambdaExt", "buildClientStreamingBaseImpl", "buildClientStreamingMethodBaseImplDelegate", "buildClientStubCompanion", "Lcom/squareup/kotlinpoet/TypeSpec;", "buildClientStubImpl", "buildClientStubRpcMethods", "buildClientStubRpcRequestOverloads", "buildGrpcFileSpec", "Lcom/squareup/kotlinpoet/FileSpec;", "buildNewStubMethod", "buildOuterObject", "buildResponseLambdaOverloads", "buildRpcMethodAnnotation", "Lcom/squareup/kotlinpoet/AnnotationSpec;", "buildSendChannelExtFiles", "Lcom/github/marcoferrer/krotoplus/proto/ProtoMessage;", "buildSendChannelLambdaExt", "suffix", "buildSendChannelOverloads", "buildServerStreamingBaseImpl", "buildServerStreamingMethodBaseImplDelegate", "buildServiceBaseImpl", "buildServiceBaseImplDelegate", "buildStubBidiStreamingMethod", "buildStubClientStreamingMethod", "buildStubServerStreamingMethod", "buildStubServerStreamingMethodOverload", "buildStubUnaryMethod", "buildStubUnaryMethodOverload", "buildUnaryBaseImpl", "buildUnaryBaseImplDelegate", "getSendChannelMessageTypes", "protoc-gen-kroto-plus"})
public final class GrpcCoroutinesGenerator
implements Generator {
    private static final String serviceDelegateName = "ServiceDelegate";
    public static final GrpcCoroutinesGenerator INSTANCE;

    @Override
    public boolean isEnabled() {
        List<GrpcCoroutinesGenOptions> list = this.getContext().getConfig().getGrpcCoroutinesList();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"context.config.grpcCoroutinesList");
        Collection collection = list;
        return !collection.isEmpty();
    }

    private final String getOuterObjectName(@NotNull ProtoService $receiver) {
        return $receiver.getName() + "CoroutineGrpc";
    }

    private final String getBaseImplName(@NotNull ProtoService $receiver) {
        return $receiver.getName() + "ImplBase";
    }

    private final ClassName getServiceDelegateClassName(@NotNull ProtoService $receiver) {
        return new ClassName($receiver.getProtoFile().getJavaPackage(), this.getOuterObjectName($receiver), new String[]{this.getBaseImplName($receiver), serviceDelegateName});
    }

    private final ClassName getServiceJavaBaseImplClassName(@NotNull ProtoService $receiver) {
        return $receiver.getEnclosingServiceClassName().nestedClass($receiver.getName() + "ImplBase");
    }

    private final String getStubName(@NotNull ProtoService $receiver) {
        return $receiver.getName() + "CoroutineStub";
    }

    private final ClassName getStubClassName(@NotNull ProtoService $receiver) {
        return new ClassName($receiver.getProtoFile().getJavaPackage(), this.getOuterObjectName($receiver), new String[]{this.getStubName($receiver)});
    }

    @NotNull
    public PluginProtos.CodeGeneratorResponse invoke() {
        PluginProtos.CodeGeneratorResponse.Builder responseBuilder = PluginProtos.CodeGeneratorResponse.newBuilder();
        List sendChannelMessageTypes = new ArrayList();
        for (ProtoService service : this.getContext().getSchema().getProtoServices()) {
            Iterator<GrpcCoroutinesGenOptions> iterator = this.getContext().getConfig().getGrpcCoroutinesList().iterator();
            while (iterator.hasNext()) {
                Object it;
                String string;
                FileFilter fileFilter;
                Object this_$iv;
                GrpcCoroutinesGenOptions options2;
                GrpcCoroutinesGenOptions grpcCoroutinesGenOptions = options2 = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)grpcCoroutinesGenOptions, (String)"options");
                Intrinsics.checkExpressionValueIsNotNull((Object)grpcCoroutinesGenOptions.getFilter(), (String)"options.filter");
                ProtoFile protoFile = service.getProtoFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)this_$iv.getDescriptorProto().getName(), (String)"descriptorProto.name");
                if (!FileFilterExtsKt.matches(fileFilter, string)) continue;
                FileSpec fileSpec = this.buildGrpcFileSpec(service);
                if (fileSpec != null) {
                    it = this_$iv = fileSpec;
                    responseBuilder.addFile(INSTANCE.toResponseFileProto((FileSpec)it));
                }
                this_$iv = sendChannelMessageTypes;
                it = this.getSendChannelMessageTypes(service);
                CollectionsKt.addAll((Collection)this_$iv, (Iterable)it);
            }
        }
        Iterable $receiver$iv = this.buildSendChannelExtFiles(sendChannelMessageTypes);
        for (ProtoService element$iv : $receiver$iv) {
            FileSpec it = (FileSpec)element$iv;
            responseBuilder.addFile(INSTANCE.toResponseFileProto(it));
        }
        PluginProtos.CodeGeneratorResponse codeGeneratorResponse = responseBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeGeneratorResponse, (String)"responseBuilder.build()");
        return codeGeneratorResponse;
    }

    private final FileSpec buildGrpcFileSpec(@NotNull ProtoService $receiver) {
        FileSpec.Builder fileSpecBuilder = FileSpec.Companion.builder($receiver.getProtoFile().getJavaPackage(), this.getOuterObjectName($receiver)).addComment("THIS IS AN AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.", new Object[0]).addType(this.buildOuterObject($receiver));
        FileSpec fileSpec = fileSpecBuilder.build();
        FileSpec it = fileSpec;
        Collection collection = it.getMembers();
        return !collection.isEmpty() ? fileSpec : null;
    }

    private final TypeSpec buildOuterObject(@NotNull ProtoService $receiver) {
        return TypeSpec.Companion.objectBuilder(this.getOuterObjectName($receiver)).addAnnotation(ProtoFileKt.getGeneratedAnnotationSpec($receiver.getProtoFile())).addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("newStub"), (TypeName)((TypeName)this.getStubClassName($receiver)), null, (int)2, null).addParameter("channel", (TypeName)CommonClassNames.INSTANCE.getGrpcChannel(), new KModifier[0]).addCode("return %T.newStub(channel)", new Object[]{this.getStubClassName($receiver)}).build()).addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("newStubWithContext"), (TypeName)((TypeName)this.getStubClassName($receiver)), null, (int)2, null).addModifiers(new KModifier[]{KModifier.SUSPEND}).addParameter("channel", (TypeName)CommonClassNames.INSTANCE.getGrpcChannel(), new KModifier[0]).addCode("return %T.newStubWithContext(channel)", new Object[]{this.getStubClassName($receiver)}).build()).addType(this.buildClientStubImpl($receiver)).addType(this.buildServiceBaseImpl($receiver)).addProperty(PropertySpec.Companion.builder("SERVICE_NAME", (TypeName)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class)), new KModifier[0]).addModifiers(new KModifier[]{KModifier.CONST}).initializer("%T.SERVICE_NAME", new Object[]{$receiver.getEnclosingServiceClassName()}).build()).build();
    }

    private final TypeSpec buildServiceBaseImpl(@NotNull ProtoService $receiver) {
        String delegateValName = "delegate";
        TypeSpec.Builder baseImplBuilder = TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)TypeSpec.Companion.classBuilder(this.getBaseImplName($receiver)).addModifiers(new KModifier[]{KModifier.ABSTRACT}), (TypeName)((TypeName)CommonClassNames.INSTANCE.getBindableService()), null, (int)2, null), (TypeName)((TypeName)CommonClassNames.INSTANCE.getServiceScope()), null, (int)2, null).addProperty(PropertySpec.Companion.builder(delegateValName, (TypeName)this.getServiceDelegateClassName($receiver), new KModifier[0]).addModifiers(new KModifier[]{KModifier.PRIVATE}).initializer("%T()", new Object[]{this.getServiceDelegateClassName($receiver)}).build()).addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("bindService").addModifiers(new KModifier[]{KModifier.OVERRIDE}), (TypeName)((TypeName)CommonClassNames.INSTANCE.getGrpcServerServiceDefinition()), null, (int)2, null).addCode("return %N.bindService()", new Object[]{delegateValName}).build()).addFunctions((Iterable)this.buildBaseImplRpcMethods($receiver)).addFunctions((Iterable)this.buildResponseLambdaOverloads($receiver)).addType(this.buildServiceBaseImplDelegate($receiver));
        return baseImplBuilder.build();
    }

    private final TypeSpec buildServiceBaseImplDelegate(@NotNull ProtoService $receiver) {
        return TypeSpec.Companion.classBuilder(serviceDelegateName).addModifiers(new KModifier[]{KModifier.PRIVATE, KModifier.INNER}).superclass((TypeName)this.getServiceJavaBaseImplClassName($receiver)).addFunctions((Iterable)this.buildBaseImplRpcMethodDelegates($receiver)).build();
    }

    private final FunSpec buildUnaryBaseImpl(@NotNull ProtoMethod $receiver) {
        return FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder($receiver.getFunctionName()).addModifiers(new KModifier[]{KModifier.SUSPEND, KModifier.OPEN}).addParameter("request", (TypeName)$receiver.getRequestClassName(), new KModifier[0]), (TypeName)((TypeName)$receiver.getResponseClassName()), null, (int)2, null).addCode(CodeBlock.Companion.builder().addStatement("return %T(%T.%N())", new Object[]{CommonClassNames.ServerCalls.INSTANCE.getServerCallUnimplementedUnary(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName()}).build()).build();
    }

    private final FunSpec buildUnaryBaseImplDelegate(@NotNull ProtoMethod $receiver) {
        return FunSpec.Companion.builder($receiver.getFunctionName()).addModifiers(new KModifier[]{KModifier.OVERRIDE}).addParameter("request", (TypeName)$receiver.getRequestClassName(), new KModifier[0]).addParameter("responseObserver", (TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getStreamObserver(), new TypeName[]{(TypeName)$receiver.getResponseClassName()}), new KModifier[0]).addCode(CodeBlock.Companion.builder().addStatement("%T(%T.%N(),responseObserver) {", new Object[]{CommonClassNames.ServerCalls.INSTANCE.getServerCallUnary(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName()}).indent().addStatement("%N(request)", new Object[]{$receiver.getFunctionName()}).unindent().addStatement("}", new Object[0]).build()).build();
    }

    private final FunSpec buildClientStreamingBaseImpl(@NotNull ProtoMethod $receiver) {
        return FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder($receiver.getFunctionName()).addModifiers(new KModifier[]{KModifier.SUSPEND, KModifier.OPEN}).addParameter("requestChannel", (TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getReceiveChannel(), new TypeName[]{(TypeName)$receiver.getRequestClassName()}), new KModifier[0]), (TypeName)((TypeName)$receiver.getResponseClassName()), null, (int)2, null).addCode(CodeBlock.Companion.builder().addStatement("return %T(%T.%N())", new Object[]{CommonClassNames.ServerCalls.INSTANCE.getServerCallUnimplementedUnary(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName()}).build()).build();
    }

    private final FunSpec buildClientStreamingMethodBaseImplDelegate(@NotNull ProtoMethod $receiver) {
        return FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder($receiver.getFunctionName()).addModifiers(new KModifier[]{KModifier.OVERRIDE}), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getStreamObserver(), new TypeName[]{(TypeName)$receiver.getRequestClassName()})), null, (int)2, null).addParameter("responseObserver", (TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getStreamObserver(), new TypeName[]{(TypeName)$receiver.getResponseClassName()}), new KModifier[0]).addCode(CodeBlock.Companion.builder().addStatement("val requestObserver = %T(%T.%N(),responseObserver) { requestChannel: %T ->", new Object[]{CommonClassNames.ServerCalls.INSTANCE.getServerCallClientStreaming(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName(), ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getReceiveChannel(), new TypeName[]{(TypeName)$receiver.getRequestClassName()})}).indent().addStatement("%N(requestChannel)", new Object[]{$receiver.getFunctionName()}).unindent().addStatement("}", new Object[0]).addStatement("return requestObserver", new Object[0]).build()).build();
    }

    private final FunSpec buildServerStreamingBaseImpl(@NotNull ProtoMethod $receiver) {
        return FunSpec.Companion.builder($receiver.getFunctionName()).addModifiers(new KModifier[]{KModifier.SUSPEND, KModifier.OPEN}).addParameter("request", (TypeName)$receiver.getRequestClassName(), new KModifier[0]).addParameter("responseChannel", (TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getSendChannel(), new TypeName[]{(TypeName)$receiver.getResponseClassName()}), new KModifier[0]).addCode(CodeBlock.Companion.builder().addStatement("%T(%T.%N(),responseChannel)", new Object[]{CommonClassNames.ServerCalls.INSTANCE.getServerCallUnimplementedStream(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName()}).build()).build();
    }

    private final FunSpec buildServerStreamingMethodBaseImplDelegate(@NotNull ProtoMethod $receiver) {
        return FunSpec.Companion.builder($receiver.getFunctionName()).addModifiers(new KModifier[]{KModifier.OVERRIDE}).addParameter("request", (TypeName)$receiver.getRequestClassName(), new KModifier[0]).addParameter("responseObserver", (TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getStreamObserver(), new TypeName[]{(TypeName)$receiver.getResponseClassName()}), new KModifier[0]).addCode(CodeBlock.Companion.builder().addStatement("%T(%T.%N(),responseObserver) { responseChannel: %T ->", new Object[]{CommonClassNames.ServerCalls.INSTANCE.getServerCallServerStreaming(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName(), ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getSendChannel(), new TypeName[]{(TypeName)$receiver.getResponseClassName()})}).indent().addStatement("%N(request, responseChannel)", new Object[]{$receiver.getFunctionName()}).unindent().addStatement("}", new Object[0]).build()).build();
    }

    private final FunSpec buildBidiBaseImpl(@NotNull ProtoMethod $receiver) {
        return FunSpec.Companion.builder($receiver.getFunctionName()).addModifiers(new KModifier[]{KModifier.SUSPEND, KModifier.OPEN}).addParameter("requestChannel", (TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getReceiveChannel(), new TypeName[]{(TypeName)$receiver.getRequestClassName()}), new KModifier[0]).addParameter("responseChannel", (TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getSendChannel(), new TypeName[]{(TypeName)$receiver.getResponseClassName()}), new KModifier[0]).addCode(CodeBlock.Companion.builder().addStatement("%T(%T.%N(),responseChannel)", new Object[]{CommonClassNames.ServerCalls.INSTANCE.getServerCallUnimplementedStream(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName()}).build()).build();
    }

    private final FunSpec buildBidiMethodBaseImplDelegate(@NotNull ProtoMethod $receiver) {
        return FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder($receiver.getFunctionName()).addModifiers(new KModifier[]{KModifier.OVERRIDE}), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getStreamObserver(), new TypeName[]{(TypeName)$receiver.getRequestClassName()})), null, (int)2, null).addParameter("responseObserver", (TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getStreamObserver(), new TypeName[]{(TypeName)$receiver.getResponseClassName()}), new KModifier[0]).addCode(CodeBlock.Companion.builder().addStatement("val requestChannel = %T(%T.%N(),responseObserver) { requestChannel: %T, responseChannel: %T ->", new Object[]{CommonClassNames.ServerCalls.INSTANCE.getServerCallBidiStreaming(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName(), ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getReceiveChannel(), new TypeName[]{(TypeName)$receiver.getRequestClassName()}), ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getSendChannel(), new TypeName[]{(TypeName)$receiver.getResponseClassName()})}).indent().addStatement("%N(requestChannel, responseChannel)", new Object[]{$receiver.getFunctionName()}).unindent().addStatement("}", new Object[0]).addStatement("return requestChannel", new Object[0]).build()).build();
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunSpec> buildBaseImplRpcMethods(@NotNull ProtoService $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getMethodDefinitions();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            FunSpec funSpec;
            void method;
            ProtoMethod protoMethod = (ProtoMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            switch (GrpcCoroutinesGenerator$WhenMappings.$EnumSwitchMapping$0[method.getType().ordinal()]) {
                case 1: {
                    funSpec = INSTANCE.buildUnaryBaseImpl((ProtoMethod)method);
                    break;
                }
                case 2: {
                    funSpec = INSTANCE.buildClientStreamingBaseImpl((ProtoMethod)method);
                    break;
                }
                case 3: {
                    funSpec = INSTANCE.buildServerStreamingBaseImpl((ProtoMethod)method);
                    break;
                }
                case 4: {
                    funSpec = INSTANCE.buildBidiBaseImpl((ProtoMethod)method);
                    break;
                }
                case 5: {
                    throw (Throwable)new IllegalStateException("Unknown method type");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            FunSpec funSpec2 = funSpec;
            collection.add(funSpec2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunSpec> buildBaseImplRpcMethodDelegates(@NotNull ProtoService $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getMethodDefinitions();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            FunSpec funSpec;
            void method;
            ProtoMethod protoMethod = (ProtoMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            switch (GrpcCoroutinesGenerator$WhenMappings.$EnumSwitchMapping$1[method.getType().ordinal()]) {
                case 1: {
                    funSpec = INSTANCE.buildUnaryBaseImplDelegate((ProtoMethod)method);
                    break;
                }
                case 2: {
                    funSpec = INSTANCE.buildClientStreamingMethodBaseImplDelegate((ProtoMethod)method);
                    break;
                }
                case 3: {
                    funSpec = INSTANCE.buildServerStreamingMethodBaseImplDelegate((ProtoMethod)method);
                    break;
                }
                case 4: {
                    funSpec = INSTANCE.buildBidiMethodBaseImplDelegate((ProtoMethod)method);
                    break;
                }
                case 5: {
                    throw (Throwable)new IllegalStateException("Unknown method type");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            FunSpec funSpec2 = funSpec;
            collection.add(funSpec2);
        }
        return (List)destination$iv$iv;
    }

    private final List<FunSpec> buildResponseLambdaOverloads(@NotNull ProtoService $receiver) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$receiver.getMethodDefinitions()), (Function1)buildResponseLambdaOverloads.1.INSTANCE), (Function1)buildResponseLambdaOverloads.2.INSTANCE), (Function1)buildResponseLambdaOverloads.3.INSTANCE));
    }

    private final FunSpec buildChannelLambdaExt(@NotNull ProtoMethod $receiver) {
        ParameterizedTypeName receiverClassName = ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getSendChannel(), new TypeName[]{(TypeName)$receiver.getResponseClassName()});
        String string = $receiver.getResponseType().getJavaPackage();
        String string2 = $receiver.getResponseType().getCanonicalJavaName();
        String string3 = string;
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string3;
        String jvmNameSuffix = StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)string4, (String)"", (boolean)false, (int)4, null), (String)".", (String)"", (boolean)false, (int)4, null);
        ProtoType protoType = $receiver.getResponseType();
        if (protoType == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.github.marcoferrer.krotoplus.proto.ProtoMessage");
        }
        return FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder("send").addModifiers(new KModifier[]{KModifier.INLINE, KModifier.SUSPEND}), (TypeName)((TypeName)receiverClassName), null, (int)2, null).addParameter("block", (TypeName)LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, (TypeName)((TypeName)((ProtoMessage)protoType).getBuilderClassName()), null, (TypeName)((TypeName)TypeNames.UNIT), (int)2, null), new KModifier[0]).addAnnotation(AnnotationSpec.Companion.builder(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(JvmName.class))).addMember("\"send" + jvmNameSuffix + '\"', new Object[0]).build()).addCode(CodeBlock.Companion.builder().addStatement("val response = %T.newBuilder().apply(block).build()", new Object[]{$receiver.getResponseClassName()}).addStatement("send(response)", new Object[0]).build()).build();
    }

    private final TypeSpec buildClientStubImpl(@NotNull ProtoService $receiver) {
        String paramNameChannel = "channel";
        String paramNameCallOptions = "callOptions";
        return TypeSpec.Companion.classBuilder(this.getStubName($receiver)).superclass((TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getGrpcAbstractStub(), new TypeName[]{(TypeName)this.getStubClassName($receiver)})).addSuperclassConstructorParameter(paramNameChannel, new Object[0]).addSuperclassConstructorParameter(paramNameCallOptions, new Object[0]).primaryConstructor(FunSpec.Companion.constructorBuilder().addModifiers(new KModifier[]{KModifier.PRIVATE}).addParameter(paramNameChannel, (TypeName)CommonClassNames.INSTANCE.getGrpcChannel(), new KModifier[0]).addParameter(ParameterSpec.Companion.builder(paramNameCallOptions, (TypeName)CommonClassNames.INSTANCE.getGrpcCallOptions(), new KModifier[0]).defaultValue("%T.DEFAULT", new Object[]{CommonClassNames.INSTANCE.getGrpcCallOptions()}).build()).build()).addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("build").addModifiers(new KModifier[]{KModifier.OVERRIDE}).addParameter(paramNameChannel, (TypeName)CommonClassNames.INSTANCE.getGrpcChannel(), new KModifier[0]).addParameter(paramNameCallOptions, (TypeName)CommonClassNames.INSTANCE.getGrpcCallOptions(), new KModifier[0]), (TypeName)((TypeName)this.getStubClassName($receiver)), null, (int)2, null).addStatement("return %T(channel,callOptions)", new Object[]{this.getStubClassName($receiver)}).build()).addFunctions((Iterable)this.buildClientStubRpcMethods($receiver)).addFunctions((Iterable)this.buildClientStubRpcRequestOverloads($receiver)).addType(this.buildClientStubCompanion($receiver)).build();
    }

    private final TypeSpec buildClientStubCompanion(@NotNull ProtoService $receiver) {
        return TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)TypeSpec.Companion.companionObjectBuilder$default((TypeSpec.Companion)TypeSpec.Companion, null, (int)1, null), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getStubDefinition(), new TypeName[]{(TypeName)this.getStubClassName($receiver)})), null, (int)2, null).addProperty(PropertySpec.Companion.builder("serviceName", (TypeName)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(String.class)), new KModifier[0]).addModifiers(new KModifier[]{KModifier.OVERRIDE}).initializer("%T.SERVICE_NAME", new Object[]{$receiver.getEnclosingServiceClassName()}).build()).addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("newStub"), (TypeName)((TypeName)this.getStubClassName($receiver)), null, (int)2, null).addModifiers(new KModifier[]{KModifier.OVERRIDE}).addParameter("channel", (TypeName)CommonClassNames.INSTANCE.getGrpcChannel(), new KModifier[0]).addCode("return %T(channel)", new Object[]{this.getStubClassName($receiver)}).build()).addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("newStubWithContext"), (TypeName)((TypeName)this.getStubClassName($receiver)), null, (int)2, null).addModifiers(new KModifier[]{KModifier.OVERRIDE, KModifier.SUSPEND}).addParameter("channel", (TypeName)CommonClassNames.INSTANCE.getGrpcChannel(), new KModifier[0]).addCode("return %T(channel).%T()", new Object[]{this.getStubClassName($receiver), CommonClassNames.INSTANCE.getWithCoroutineContext()}).build()).build();
    }

    private final FunSpec buildNewStubMethod(@NotNull ProtoService $receiver) {
        return FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("newStub"), (TypeName)((TypeName)this.getStubClassName($receiver)), null, (int)2, null).addParameter("channel", (TypeName)CommonClassNames.INSTANCE.getGrpcChannel(), new KModifier[0]).addCode("return %T.newStub(channel)", new Object[]{this.getStubClassName($receiver)}).build();
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunSpec> buildClientStubRpcMethods(@NotNull ProtoService $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getMethodDefinitions();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            FunSpec funSpec;
            void method;
            ProtoMethod protoMethod = (ProtoMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            switch (GrpcCoroutinesGenerator$WhenMappings.$EnumSwitchMapping$2[method.getType().ordinal()]) {
                case 1: {
                    funSpec = INSTANCE.buildStubUnaryMethod((ProtoMethod)method);
                    break;
                }
                case 2: {
                    funSpec = INSTANCE.buildStubClientStreamingMethod((ProtoMethod)method);
                    break;
                }
                case 3: {
                    funSpec = INSTANCE.buildStubServerStreamingMethod((ProtoMethod)method);
                    break;
                }
                case 4: {
                    funSpec = INSTANCE.buildStubBidiStreamingMethod((ProtoMethod)method);
                    break;
                }
                case 5: {
                    throw (Throwable)new IllegalStateException("Unknown method type");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            FunSpec funSpec2 = funSpec;
            collection.add(funSpec2);
        }
        return (List)destination$iv$iv;
    }

    private final FunSpec buildStubBidiStreamingMethod(@NotNull ProtoMethod $receiver) {
        return FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder($receiver.getFunctionName()).addAnnotation(this.buildRpcMethodAnnotation($receiver)), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.ClientChannels.INSTANCE.getClientBidiCallChannel(), new TypeName[]{(TypeName)$receiver.getRequestClassName(), (TypeName)$receiver.getResponseClassName()})), null, (int)2, null).addStatement("return %T(%T.%N())", new Object[]{CommonClassNames.ClientCalls.INSTANCE.getClientCallBidiStreaming(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName()}).build();
    }

    private final FunSpec buildSendChannelLambdaExt(@NotNull ProtoMessage $receiver, String suffix) {
        ClassName $receiver$iv;
        String string = $receiver.getJavaPackage();
        String string2 = $receiver.getCanonicalJavaName();
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string;
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string3;
        String jvmNameSuffix = stringBuilder.append(StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)string4, (String)"", (boolean)false, (int)4, null), (String)".", (String)"", (boolean)false, (int)4, null)).append(suffix).toString();
        string = $receiver.getClassName();
        string2 = "block";
        stringBuilder = FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder("send").addModifiers(new KModifier[]{KModifier.INLINE, KModifier.SUSPEND}).addAnnotation(AnnotationSpec.Companion.builder(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(JvmName.class))).addMember("\"send" + jvmNameSuffix + '\"', new Object[0]).build()), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getSendChannel(), new TypeName[]{(TypeName)$receiver.getClassName()})), null, (int)2, null);
        string4 = LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, (TypeName)((TypeName)$receiver$iv.nestedClass("Builder")), null, (TypeName)((TypeName)TypeNames.UNIT), (int)2, null);
        $receiver$iv = $receiver.getClassName();
        stringBuilder = stringBuilder.addParameter(string2, (TypeName)string4, new KModifier[0]);
        string2 = CodeBlock.Companion.of("val request = %T.newBuilder().apply(block).build()\n", new Object[]{$receiver$iv});
        return stringBuilder.addCode((CodeBlock)string2).addStatement("send(request)", new Object[0]).build();
    }

    static /* synthetic */ FunSpec buildSendChannelLambdaExt$default(GrpcCoroutinesGenerator grpcCoroutinesGenerator, ProtoMessage protoMessage, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return grpcCoroutinesGenerator.buildSendChannelLambdaExt(protoMessage, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FunSpec> buildSendChannelOverloads(@NotNull ProtoService $receiver) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Iterable $receiver$iv = this.getSendChannelMessageTypes($receiver);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProtoMessage protoMessage = (ProtoMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            FunSpec funSpec = GrpcCoroutinesGenerator.buildSendChannelLambdaExt$default(INSTANCE, (ProtoMessage)it, null, 1, null);
            collection.add(funSpec);
        }
        return (List)destination$iv$iv;
    }

    private final List<ProtoMessage> getSendChannelMessageTypes(@NotNull ProtoService $receiver) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$receiver.getMethodDefinitions()), (Function1)getSendChannelMessageTypes.1.INSTANCE), (Function1)getSendChannelMessageTypes.2.INSTANCE), (Function1)getSendChannelMessageTypes.3.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileSpec> buildSendChannelExtFiles(@NotNull List<ProtoMessage> $receiver) {
        FunSpec funSpec;
        Object object;
        Object $receiver$iv$iv;
        Object $receiver$iv = CollectionsKt.distinct((Iterable)$receiver);
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Object object2 = $receiver$iv$iv.iterator();
        while (object2.hasNext()) {
            Object object3;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object2.next();
            ProtoMessage it = (ProtoMessage)element$iv$iv;
            ProtoFile key$iv$iv = it.getProtoFile();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            it = (ProtoMessage)element$iv$iv;
            object = list$iv$iv;
            funSpec = GrpcCoroutinesGenerator.buildSendChannelLambdaExt$default(INSTANCE, it, null, 1, null);
            object.add(funSpec);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList($receiver$iv.size());
        object2 = $receiver$iv$iv;
        Iterator iterator = object2.entrySet().iterator();
        while (iterator.hasNext()) {
            void $protoFile_funSpecs;
            Map.Entry item$iv$iv;
            Map.Entry $i$a$2$groupBy = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            void var9_8 = $protoFile_funSpecs;
            ProtoFile protoFile = (ProtoFile)var9_8.getKey();
            var9_8 = $protoFile_funSpecs;
            List funSpecs = (List)var9_8.getValue();
            funSpec = CodeBuilderExtsKt.addFunctions(FileSpec.Companion.builder(protoFile.getJavaPackage(), protoFile.getJavaOuterClassname() + "GrpcExts"), funSpecs).build();
            object.add(funSpec);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunSpec> buildClientStubRpcRequestOverloads(@NotNull ProtoService $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getMethodDefinitions();
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FunSpec funSpec;
            FunSpec funSpec2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            ProtoMethod it = (ProtoMethod)element$iv$iv;
            switch (GrpcCoroutinesGenerator$WhenMappings.$EnumSwitchMapping$3[it.getType().ordinal()]) {
                case 1: {
                    funSpec2 = INSTANCE.buildStubUnaryMethodOverload(it);
                    break;
                }
                case 2: {
                    funSpec2 = INSTANCE.buildStubServerStreamingMethodOverload(it);
                    break;
                }
                default: {
                    funSpec2 = null;
                }
            }
            if (funSpec2 == null) continue;
            FunSpec it$iv$iv = funSpec = funSpec2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final AnnotationSpec buildRpcMethodAnnotation(@NotNull ProtoMethod $receiver) {
        return AnnotationSpec.Companion.builder(CommonClassNames.INSTANCE.getGrpcStubRpcMethod()).addMember("fullMethodName = \"$SERVICE_NAME/" + $receiver.getDescriptorProto().getName() + '\"', new Object[0]).addMember("requestType = %T::class", new Object[]{$receiver.getRequestClassName()}).addMember("responseType = %T::class", new Object[]{$receiver.getResponseClassName()}).addMember("methodType = %T.%N", new Object[]{Reflection.getOrCreateKotlinClass(MethodDescriptor.MethodType.class), $receiver.getType().name()}).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FunSpec buildStubUnaryMethod(@NotNull ProtoMethod $receiver) {
        void $receiver$iv;
        ClassName className = $receiver.getRequestClassName();
        FunSpec.Builder builder = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder($receiver.getFunctionName()).addAnnotation(this.buildRpcMethodAnnotation($receiver)).addModifiers(new KModifier[]{KModifier.SUSPEND}), (TypeName)((TypeName)$receiver.getResponseClassName()), null, (int)2, null);
        ParameterSpec parameterSpec = ParameterSpec.Companion.builder("request", (TypeName)$receiver$iv, new KModifier[0]).defaultValue("%T.getDefaultInstance()", new Object[]{$receiver$iv}).build();
        return builder.addParameter(parameterSpec).addStatement("return %T(request, %T.%N())", new Object[]{CommonClassNames.ClientCalls.INSTANCE.getClientCallUnary(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName()}).build();
    }

    private final FunSpec buildStubUnaryMethodOverload(@NotNull ProtoMethod $receiver) {
        ClassName $receiver$iv;
        ClassName className = $receiver.getRequestClassName();
        String string = "block";
        FunSpec.Builder builder = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder($receiver.getFunctionName()).addModifiers(new KModifier[]{KModifier.SUSPEND, KModifier.INLINE}), (TypeName)((TypeName)$receiver.getResponseClassName()), null, (int)2, null);
        LambdaTypeName lambdaTypeName = LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, (TypeName)((TypeName)$receiver$iv.nestedClass("Builder")), null, (TypeName)((TypeName)TypeNames.UNIT), (int)2, null);
        $receiver$iv = $receiver.getRequestClassName();
        builder = builder.addParameter(string, (TypeName)lambdaTypeName, new KModifier[0]);
        string = CodeBlock.Companion.of("val request = %T.newBuilder().apply(block).build()\n", new Object[]{$receiver$iv});
        return builder.addCode((CodeBlock)string).addStatement("return %N(request)", new Object[]{$receiver.getFunctionName()}).build();
    }

    private final FunSpec buildStubServerStreamingMethodOverload(@NotNull ProtoMethod $receiver) {
        ClassName $receiver$iv;
        ClassName className = $receiver.getRequestClassName();
        String string = "block";
        FunSpec.Builder builder = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder($receiver.getFunctionName()).addModifiers(new KModifier[]{KModifier.INLINE}), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getReceiveChannel(), new TypeName[]{(TypeName)$receiver.getResponseClassName()})), null, (int)2, null);
        LambdaTypeName lambdaTypeName = LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, (TypeName)((TypeName)$receiver$iv.nestedClass("Builder")), null, (TypeName)((TypeName)TypeNames.UNIT), (int)2, null);
        $receiver$iv = $receiver.getRequestClassName();
        builder = builder.addParameter(string, (TypeName)lambdaTypeName, new KModifier[0]);
        string = CodeBlock.Companion.of("val request = %T.newBuilder().apply(block).build()\n", new Object[]{$receiver$iv});
        return builder.addCode((CodeBlock)string).addStatement("return %N(request)", new Object[]{$receiver.getFunctionName()}).build();
    }

    private final FunSpec buildStubClientStreamingMethod(@NotNull ProtoMethod $receiver) {
        return FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder($receiver.getFunctionName()).addAnnotation(this.buildRpcMethodAnnotation($receiver)), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.ClientChannels.INSTANCE.getClientStreamingCallChannel(), new TypeName[]{(TypeName)$receiver.getRequestClassName(), (TypeName)$receiver.getResponseClassName()})), null, (int)2, null).addStatement("return %T(%T.%N())", new Object[]{CommonClassNames.ClientCalls.INSTANCE.getClientCallClientStreaming(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName()}).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FunSpec buildStubServerStreamingMethod(@NotNull ProtoMethod $receiver) {
        void $receiver$iv;
        ClassName className = $receiver.getRequestClassName();
        FunSpec.Builder builder = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder($receiver.getFunctionName()).addAnnotation(this.buildRpcMethodAnnotation($receiver)), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(CommonClassNames.INSTANCE.getReceiveChannel(), new TypeName[]{(TypeName)$receiver.getResponseClassName()})), null, (int)2, null);
        ParameterSpec parameterSpec = ParameterSpec.Companion.builder("request", (TypeName)$receiver$iv, new KModifier[0]).defaultValue("%T.getDefaultInstance()", new Object[]{$receiver$iv}).build();
        return builder.addParameter(parameterSpec).addStatement("return %T(request, %T.%N())", new Object[]{CommonClassNames.ClientCalls.INSTANCE.getClientCallServerStreaming(), $receiver.getProtoService().getEnclosingServiceClassName(), $receiver.getMethodDefinitionGetterName()}).build();
    }

    private GrpcCoroutinesGenerator() {
    }

    static {
        GrpcCoroutinesGenerator grpcCoroutinesGenerator;
        INSTANCE = grpcCoroutinesGenerator = new GrpcCoroutinesGenerator();
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return Generator.DefaultImpls.getContext(this);
    }

    @Override
    @NotNull
    public PluginProtos.CodeGeneratorResponse.File toResponseFileProto(@NotNull FileSpec $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Generator.DefaultImpls.toResponseFileProto(this, $receiver);
    }

    @NotNull
    public static final /* synthetic */ FunSpec access$buildChannelLambdaExt(GrpcCoroutinesGenerator $this, @NotNull ProtoMethod $receiver) {
        return $this.buildChannelLambdaExt($receiver);
    }
}

