/*
 * Decompiled with CFR 0.152.
 */
package com.github.marcoferrer.krotoplus.script;

import com.github.marcoferrer.krotoplus.Manifest;
import com.github.marcoferrer.krotoplus.generators.GeneratorKt;
import com.github.marcoferrer.krotoplus.script.RenderScript;
import com.github.marcoferrer.krotoplus.script.ScriptManager;
import com.github.marcoferrer.krotoplus.script.ScriptManagerKt;
import com.github.marcoferrer.krotoplus.utils.MemoizeKt;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.CompiledScript;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.KotlinJsr223JvmScriptEngineBase;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.script.jsr223.KotlinJsr223JvmLocalScriptEngine;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0015\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001eJ!\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00042\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u001eJ\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u001e\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/github/marcoferrer/krotoplus/script/ScriptManager;", "", "()V", "cacheDirPath", "", "compileCacheDir", "Ljava/io/File;", "getFileContentToHash", "Lkotlin/Function1;", "Lkotlin/Pair;", "scriptBundleClassLoaders", "", "Ljava/lang/ClassLoader;", "scriptCache", "Lcom/github/marcoferrer/krotoplus/script/RenderScript;", "scriptEngine", "Lorg/jetbrains/kotlin/script/jsr223/KotlinJsr223JvmLocalScriptEngine;", "getScriptEngine", "()Lorg/jetbrains/kotlin/script/jsr223/KotlinJsr223JvmLocalScriptEngine;", "scriptEngine$delegate", "Lkotlin/Lazy;", "compileAndWriteToFs", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult$CompiledClasses;", "cacheFile", "scriptContents", "getClassLoaderForBundle", "bundle", "getOrLoadCompiledClasses", "scriptFile", "getScript", "getScript$protoc_gen_kroto_plus", "scriptPath", "bundlePath", "getScriptFromBundle", "loadScriptClass", "Ljava/lang/Class;", "protoc-gen-kroto-plus"})
public final class ScriptManager {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final String cacheDirPath;
    private static final File compileCacheDir;
    private static final Lazy scriptEngine$delegate;
    private static final Map<String, RenderScript> scriptCache;
    private static final Map<String, ClassLoader> scriptBundleClassLoaders;
    private static final Function1<File, Pair<String, String>> getFileContentToHash;
    public static final ScriptManager INSTANCE;

    static {
        File file;
        ScriptManager scriptManager;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ScriptManager.class), "scriptEngine", "getScriptEngine()Lorg/jetbrains/kotlin/script/jsr223/KotlinJsr223JvmLocalScriptEngine;"))};
        INSTANCE = scriptManager = new ScriptManager();
        String string = System.getProperty("krotoplus.script.cache.dir");
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = System.getProperty("user.home");
            if (string2 == null) {
                string2 = System.getProperty("HOME");
            }
            string = stringBuilder.append(string2).append("/.kroto/cache/").append(Manifest.INSTANCE.getImplVersion()).toString();
        }
        cacheDirPath = string;
        File $receiver = file = new File(cacheDirPath);
        $receiver.mkdirs();
        compileCacheDir = file;
        scriptEngine$delegate = LazyKt.lazy((Function0)scriptEngine.2.INSTANCE);
        scriptCache = new LinkedHashMap();
        scriptBundleClassLoaders = new LinkedHashMap();
        getFileContentToHash = MemoizeKt.memoize(getFileContentToHash.1.INSTANCE);
    }

    private final KotlinJsr223JvmLocalScriptEngine getScriptEngine() {
        Lazy lazy = scriptEngine$delegate;
        ScriptManager scriptManager = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (KotlinJsr223JvmLocalScriptEngine)lazy.getValue();
    }

    private final Class<?> loadScriptClass(String scriptPath, File bundle) {
        String string;
        String string2;
        boolean bl = bundle.exists();
        if (!bl) {
            String string3 = "Bundle not found: " + bundle.getAbsolutePath();
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        String $i$a$1$require = scriptPath;
        CharSequence it = $i$a$1$require;
        String string4 = !StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)"/", (boolean)false, (int)2, null) ? $i$a$1$require : null;
        if (string4 != null && (string4 = StringsKt.substringBeforeLast$default((String)string4, (String)"/", null, (int)2, null)) != null && (string4 = StringsKt.replace$default((String)string4, (String)"/", (String)".", (boolean)false, (int)4, null)) != null) {
            it = $i$a$1$require = string4;
            string2 = it + '.';
        } else {
            string2 = null;
        }
        if ((string = ($i$a$1$require = string2)) == null) {
            string = "";
        }
        String scriptPackage = string;
        it = StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)scriptPath, (String)"/", null, (int)2, null), (String)".", null, (int)2, null);
        Regex regex = new Regex("[.-]");
        String string5 = "_";
        String scriptName = StringsKt.capitalize((String)regex.replace(it, string5));
        ClassLoader classLoader = this.getClassLoaderForBundle(bundle);
        return Class.forName(scriptPackage + scriptName, true, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassLoader getClassLoaderForBundle(File bundle) {
        Object object;
        void $receiver$iv;
        Map<String, ClassLoader> map = scriptBundleClassLoaders;
        String string = bundle.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bundle.absolutePath");
        String key$iv = string;
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            URLClassLoader answer$iv = new URLClassLoader(new URL[]{bundle.toURI().toURL()}, INSTANCE.getClass().getClassLoader());
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ClassLoader)object;
    }

    /*
     * WARNING - void declaration
     */
    private final RenderScript getScriptFromBundle(String scriptPath, File bundle) {
        Object object;
        void $receiver$iv;
        Map<String, RenderScript> map = scriptCache;
        String key$iv = bundle.getAbsolutePath() + '/' + scriptPath;
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            String[] stringArray;
            Object[] objectArray;
            Class<?> clazz;
            Class<?> clazz2 = INSTANCE.loadScriptClass(scriptPath, bundle);
            if (clazz2 == null) {
                throw (Throwable)new IllegalArgumentException("Script: '" + scriptPath + "' was not found in bundle '" + bundle.getAbsolutePath() + '\'');
            }
            Class<?> clazz3 = clazz = clazz2;
            int n = 0;
            Object[] objectArray2 = objectArray = new Object[1];
            Constructor<?> constructor = clazz3.getConstructor(String[].class);
            objectArray[n] = stringArray = new String[0];
            Object instance = constructor.newInstance(objectArray2);
            RenderScript answer$iv = new RenderScript(Reflection.getOrCreateKotlinClass(instance.getClass()), null, instance, 2, null);
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (RenderScript)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RenderScript getScript$protoc_gen_kroto_plus(@NotNull File scriptFile) {
        Object object;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)scriptFile, (String)"scriptFile");
        Map<String, RenderScript> map = scriptCache;
        String string = scriptFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scriptFile.absolutePath");
        String key$iv = string;
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            RenderScript answer$iv = ScriptManagerKt.access$toRenderScript(INSTANCE.getOrLoadCompiledClasses(scriptFile), INSTANCE.getScriptEngine());
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (RenderScript)object;
    }

    @NotNull
    public final RenderScript getScript$protoc_gen_kroto_plus(@NotNull String scriptPath, @Nullable String bundlePath) {
        Intrinsics.checkParameterIsNotNull((Object)scriptPath, (String)"scriptPath");
        CharSequence charSequence = bundlePath;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            charSequence2 = "";
        }
        charSequence = charSequence2;
        return charSequence.length() > 0 ? this.getScriptFromBundle(scriptPath, new File(GeneratorKt.getContext(this).getCurrentWorkingDir(), bundlePath)) : this.getScript$protoc_gen_kroto_plus(new File(GeneratorKt.getContext(this).getCurrentWorkingDir(), scriptPath));
    }

    @NotNull
    public static /* synthetic */ RenderScript getScript$protoc_gen_kroto_plus$default(ScriptManager scriptManager, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return scriptManager.getScript$protoc_gen_kroto_plus(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ReplCompileResult.CompiledClasses getOrLoadCompiledClasses(File scriptFile) {
        Object object;
        void fileContent;
        Pair pair = (Pair)getFileContentToHash.invoke((Object)scriptFile);
        String string = (String)pair.component1();
        String checksum = (String)pair.component2();
        File cachedFile = new File(compileCacheDir, checksum + ".kts.compiled");
        if (cachedFile.exists()) {
            Object object2;
            try {
                ReplCompileResult.CompiledClasses compiledClasses;
                object2 = cachedFile;
                object2 = new FileInputStream((File)object2);
                Throwable throwable = null;
                try {
                    Object object3;
                    FileInputStream fis = (FileInputStream)object2;
                    Closeable closeable = new ObjectInputStream(fis);
                    Throwable throwable2 = null;
                    try {
                        ObjectInputStream it = (ObjectInputStream)closeable;
                        Object object4 = it.readObject();
                        object3 = object4;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    }
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.repl.ReplCompileResult.CompiledClasses");
                    }
                    compiledClasses = (ReplCompileResult.CompiledClasses)object3;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                object2 = compiledClasses;
            }
            catch (EOFException e) {
                object2 = this.compileAndWriteToFs(cachedFile, (String)fileContent);
            }
            object = object2;
        } else {
            object = this.compileAndWriteToFs(cachedFile, (String)fileContent);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ReplCompileResult.CompiledClasses compileAndWriteToFs(File cacheFile, String scriptContents) {
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
        cacheFile.createNewFile();
        CompiledScript compiledScript = this.getScriptEngine().compile(scriptContents);
        if (compiledScript == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.repl.KotlinJsr223JvmScriptEngineBase.CompiledKotlinScript");
        }
        KotlinJsr223JvmScriptEngineBase.CompiledKotlinScript compiledScript2 = (KotlinJsr223JvmScriptEngineBase.CompiledKotlinScript)compiledScript;
        Object object = cacheFile;
        object = new FileOutputStream((File)object);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)object;
            Closeable closeable = new ObjectOutputStream(fos);
            Throwable throwable2 = null;
            try {
                ObjectOutputStream it = (ObjectOutputStream)closeable;
                it.writeObject(compiledScript2.getCompiledData());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return compiledScript2.getCompiledData();
    }

    private ScriptManager() {
    }
}

