/*
 * Decompiled with CFR 0.152.
 */
package fr.ms.lang;

import java.util.HashSet;
import java.util.Set;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static final boolean classPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static final Class[] findInterfaces(Class cls) {
        if (cls == null) {
            return null;
        }
        HashSet interfacesFound = new HashSet();
        ClassUtils.getAllInterfaces(cls, interfacesFound);
        Class[] interfaces = interfacesFound.toArray(new Class[interfacesFound.size()]);
        return interfaces;
    }

    private static final void getAllInterfaces(Class clazz, Set interfacesFound) {
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> inter = interfaces[i];
                if (!interfacesFound.add(inter)) continue;
                ClassUtils.getAllInterfaces(inter, interfacesFound);
            }
            clazz = clazz.getSuperclass();
        }
    }
}

