/*
 * Decompiled with CFR 0.152.
 */
package fr.ms.lang;

import fr.ms.lang.delegate.DefaultStringMakerFactory;
import fr.ms.lang.delegate.StringMakerFactory;
import fr.ms.lang.stringmaker.impl.StringMaker;

public final class StringUtils {
    private static final StringMakerFactory stringMakerFactory = DefaultStringMakerFactory.getInstance();

    private StringUtils() {
    }

    public static String padRight(String s, int n) {
        StringMaker sb = stringMakerFactory.newString();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String padRight(String start, String s, int n) {
        return start + StringUtils.padRight(s, n - start.length());
    }

    public static String replaceAll(String str, String replace, String replacement) {
        StringMaker sb = stringMakerFactory.newString(str);
        int firstOccurrence = sb.toString().indexOf(replace);
        while (firstOccurrence != -1) {
            sb.replace(firstOccurrence, firstOccurrence + replace.length(), replacement);
            int position = firstOccurrence + replacement.length();
            firstOccurrence = sb.toString().indexOf(replace, position);
        }
        return sb.toString();
    }

    public static String removePart(String str, String start, String end) {
        return StringUtils.removePart(str, start, end, null, new Integer(0));
    }

    public static String removePart(String str, String start, String end, String exception) {
        return StringUtils.removePart(str, start, end, exception, new Integer(0));
    }

    public static int beginPart(String str, String start, String end, String exception, int first) {
        int startException;
        if (str == null || str.isEmpty()) {
            return -1;
        }
        int startComment = str.indexOf(start, first);
        int endComment = str.indexOf(end, first);
        if (startComment == -1 || endComment == -1 || startComment >= endComment) {
            return -1;
        }
        if (exception != null && startComment == (startException = str.indexOf(exception))) {
            int beginPart = StringUtils.beginPart(str, start, end, exception, endComment + end.length());
            return beginPart;
        }
        if (startComment > first) {
            return first;
        }
        return endComment + end.length();
    }

    private static String removePart(String str, String start, String end, String exception, Integer first) {
        int startException;
        if (str == null || str.isEmpty()) {
            return null;
        }
        int startComment = str.indexOf(start, (int)first);
        int endComment = str.indexOf(end, (int)first);
        if (startComment == -1 || endComment == -1 || startComment >= endComment) {
            return str;
        }
        if (exception != null && startComment == (startException = str.indexOf(exception))) {
            String formatSql = StringUtils.removePart(str, start, end, exception, new Integer(endComment + end.length()));
            return formatSql;
        }
        String e1 = str.substring(0, startComment);
        String e2 = str.substring(endComment + end.length(), str.length());
        String replace = e1 + e2;
        String formatSql = StringUtils.removePart(replace, start, end, exception, first);
        return formatSql;
    }
}

