/*
 * Decompiled with CFR 0.152.
 */
package fr.ms.lang.ref;

import fr.ms.lang.ref.ReferenceObject;
import fr.ms.util.logging.Logger;
import fr.ms.util.logging.LoggerManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

public class NotifyReferenceObject
implements ReferenceObject {
    private static final Logger LOG = LoggerManager.getLogger(class$fr$ms$lang$ref$NotifyReferenceObject == null ? (class$fr$ms$lang$ref$NotifyReferenceObject = NotifyReferenceObject.class$("fr.ms.lang.ref.NotifyReferenceObject")) : class$fr$ms$lang$ref$NotifyReferenceObject);
    private static final String nl = System.getProperty("line.separator");
    private final String message;
    private final Reference reference;
    private boolean firstCleanGC = true;
    static /* synthetic */ Class class$fr$ms$lang$ref$NotifyReferenceObject;

    NotifyReferenceObject(String message, Reference reference) {
        this.message = message;
        this.reference = reference;
    }

    public void clear() {
        this.reference.clear();
    }

    public boolean enqueue() {
        return this.reference.enqueue();
    }

    public Object get() {
        Object obj = this.reference.get();
        if (this.firstCleanGC && obj == null) {
            if (LOG.isWarnEnabled()) {
                StringWriter sw = new StringWriter();
                new Throwable().printStackTrace(new PrintWriter(sw));
                String stackTrace = sw.toString();
                LOG.warn(this.message + nl + stackTrace);
            }
            this.firstCleanGC = false;
        }
        return obj;
    }

    public boolean isEnqueued() {
        return this.reference.isEnqueued();
    }

    static ReferenceObject newSoftReference(String message, Object referent) {
        SoftReference<Object> soft = new SoftReference<Object>(referent);
        return new NotifyReferenceObject(message, soft);
    }

    public String toString() {
        return this.reference.get().toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

