/*
 * Decompiled with CFR 0.152.
 */
package fr.ms.lang.reflect;

import fr.ms.lang.ClassUtils;
import fr.ms.util.logging.Logger;
import fr.ms.util.logging.LoggerManager;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class ImplementationDecorator
implements InvocationHandler {
    private static final Logger LOG = LoggerManager.getLogger(class$fr$ms$lang$reflect$ImplementationDecorator == null ? (class$fr$ms$lang$reflect$ImplementationDecorator = ImplementationDecorator.class$("fr.ms.lang.reflect.ImplementationDecorator")) : class$fr$ms$lang$reflect$ImplementationDecorator);
    private final Object impl;
    private final ImplementationProxy ip;
    static /* synthetic */ Class class$fr$ms$lang$reflect$ImplementationDecorator;

    public ImplementationDecorator(Object impl, ImplementationProxy ip) {
        if (ip == null) {
            throw new NullPointerException();
        }
        this.impl = impl;
        this.ip = ip;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object invoke;
        Object createProxy;
        if (LOG.isDebugEnabled()) {
            String declaringClass = method.getDeclaringClass().getName();
            String name = method.getName();
            LOG.debug(declaringClass + "." + name);
        }
        if ((createProxy = this.ip.createProxy(this, invoke = method.invoke(this.impl, args))) != invoke) {
            return createProxy;
        }
        if (invoke != null) {
            Class<?> clazz = invoke.getClass();
            Class<?> returnType = method.getReturnType();
            boolean isPrimitive = clazz.isPrimitive() && returnType.isPrimitive();
            boolean isInterface = returnType.isInterface();
            if (!isPrimitive && isInterface) {
                boolean isArray = returnType.isArray();
                if (isArray) {
                    Object[] invokes = (Object[])invoke;
                    if (invokes.length == 0) {
                        return invokes;
                    }
                    ArrayList<Object> liste = new ArrayList<Object>();
                    for (int i = 0; i < invokes.length; ++i) {
                        Object invokeOnly = invokes[i];
                        Object wrapObject = this.createProxy(invokeOnly);
                        liste.add(wrapObject);
                    }
                    return liste.toArray((Object[])Array.newInstance(returnType.getComponentType(), liste.size()));
                }
                Object wrapObject = this.createProxy(invoke);
                return wrapObject;
            }
        }
        return invoke;
    }

    private Object createProxy(Object impl) {
        Class<?> clazz = impl.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Class[] interfaces = ClassUtils.findInterfaces(clazz);
        if (interfaces == null || interfaces.length == 0) {
            return impl;
        }
        ImplementationDecorator ih = new ImplementationDecorator(impl, this.ip);
        Object proxy = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)ih);
        return proxy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ImplementationProxy {
        public Object createProxy(ImplementationDecorator var1, Object var2);
    }
}

