/*
 * Decompiled with CFR 0.152.
 */
package fr.ms.lang.reflect;

import fr.ms.lang.reflect.ProxyOperation;
import fr.ms.lang.reflect.ProxyOperationFactory;
import fr.ms.lang.reflect.TimeInvocation;
import fr.ms.lang.reflect.TimeInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ProxyOperationInvocationHandler
implements InvocationHandler {
    private final Object implementation;
    private final TimeInvocationHandler invocationHandler;
    private final ProxyOperationFactory factory;

    public ProxyOperationInvocationHandler(Object implementation, ProxyOperationFactory factory) {
        this.implementation = implementation;
        this.invocationHandler = new TimeInvocationHandler(this.implementation);
        this.factory = factory;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        TimeInvocation timeInvocation = (TimeInvocation)this.invocationHandler.invoke(proxy, method, args);
        Throwable targetException = timeInvocation.getTargetException();
        ProxyOperation operationContext = this.factory.newOperation(timeInvocation, proxy, method, args);
        boolean buildOperation = this.preProcess();
        if (buildOperation) {
            this.postProcess(operationContext, timeInvocation, proxy, method, args);
        }
        if (targetException != null) {
            throw targetException;
        }
        Object wrapInvoke = operationContext.getInvoke();
        return wrapInvoke;
    }

    public boolean preProcess() {
        return false;
    }

    public void postProcess(ProxyOperation operationContext, TimeInvocation timeInvocation, Object proxy, Method method, Object[] args) {
    }

    public Object getImplementation() {
        return this.implementation;
    }
}

