/*
 * Decompiled with CFR 0.152.
 */
package fr.ms.lang.reflect;

import fr.ms.lang.delegate.DefaultStringMakerFactory;
import fr.ms.lang.delegate.DefaultSyncLongFactory;
import fr.ms.lang.delegate.StringMakerFactory;
import fr.ms.lang.delegate.SyncLongFactory;
import fr.ms.lang.reflect.TimeInvocation;
import fr.ms.lang.stringmaker.impl.StringMaker;
import fr.ms.lang.sync.impl.SyncLong;
import fr.ms.util.logging.Logger;
import fr.ms.util.logging.LoggerManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class TraceTimeInvocationHandler
implements InvocationHandler {
    public static final Logger LOG = LoggerManager.getLogger(class$fr$ms$lang$reflect$TraceTimeInvocationHandler == null ? (class$fr$ms$lang$reflect$TraceTimeInvocationHandler = TraceTimeInvocationHandler.class$("fr.ms.lang.reflect.TraceTimeInvocationHandler")) : class$fr$ms$lang$reflect$TraceTimeInvocationHandler);
    private static final StringMakerFactory stringFactory = DefaultStringMakerFactory.getInstance();
    private static final SyncLongFactory syncLongFactory = DefaultSyncLongFactory.getInstance();
    private final InvocationHandler invocationHandler;
    private static long maxTime;
    private static String maxMethodName;
    private static SyncLong averageTime;
    private static SyncLong quotient;
    static /* synthetic */ Class class$fr$ms$lang$reflect$TraceTimeInvocationHandler;

    public TraceTimeInvocationHandler(InvocationHandler invocationHandler) {
        this.invocationHandler = invocationHandler;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long start = System.currentTimeMillis();
        TimeInvocation invokeTime = (TimeInvocation)this.invocationHandler.invoke(proxy, method, args);
        long end = System.currentTimeMillis();
        long time = end - start - invokeTime.getExecTime();
        String methodName = TraceTimeInvocationHandler.getMethodCall(method.getDeclaringClass().getName() + "." + method.getName(), args);
        if (time > maxTime) {
            maxTime = time;
            maxMethodName = methodName;
        }
        averageTime.addAndGet(time);
        StringMaker sb = stringFactory.newString();
        sb.append("Time Process : ");
        sb.append(time);
        sb.append(" ms - Average Time : ");
        sb.append(averageTime.get() / quotient.incrementAndGet());
        sb.append(" ms - Method Name : ");
        sb.append(methodName);
        sb.append(" - Max Time Process : ");
        sb.append(maxTime);
        sb.append(" ms - Max Method Name : ");
        sb.append(maxMethodName);
        LOG.debug(sb.toString());
        return invokeTime.getInvoke();
    }

    public static String getMethodCall(String methodName, Object[] args) {
        StringMaker sb = stringFactory.newString();
        sb.append(methodName);
        sb.append("(");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                sb.append(arg.getClass());
                if (i >= args.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append(");");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        averageTime = syncLongFactory.newLong();
        quotient = syncLongFactory.newLong();
    }
}

