/*
 * Decompiled with CFR 0.152.
 */
package fr.ms.lang.stringmaker.impl;

import fr.ms.lang.delegate.StringMakerFactory;
import fr.ms.lang.stringmaker.impl.StringMaker;

public class StringBuilderImpl
implements StringMaker {
    private static final StringMakerFactory factory = new Factory();
    private final StringBuilder delegate;

    public StringBuilderImpl() {
        this.delegate = new StringBuilder();
    }

    public StringBuilderImpl(int capacity) {
        this.delegate = new StringBuilder(capacity);
    }

    public StringBuilderImpl(String str) {
        this.delegate = new StringBuilder(str);
    }

    public StringMaker append(Object obj) {
        this.delegate.append(obj);
        return this;
    }

    public StringMaker append(String str) {
        this.delegate.append(str);
        return this;
    }

    public StringMaker append(StringBuffer sb) {
        this.delegate.append(sb);
        return this;
    }

    public StringMaker append(char[] str) {
        this.delegate.append(str);
        return this;
    }

    public StringMaker append(char[] str, int offset, int len) {
        this.delegate.append(str, offset, len);
        return this;
    }

    public StringMaker append(boolean b) {
        this.delegate.append(b);
        return this;
    }

    public StringMaker append(char c) {
        this.delegate.append(c);
        return this;
    }

    public StringMaker append(int i) {
        this.delegate.append(i);
        return this;
    }

    public StringMaker append(long l) {
        this.delegate.append(l);
        return this;
    }

    public StringMaker append(float f) {
        this.delegate.append(f);
        return this;
    }

    public StringMaker append(double d) {
        this.delegate.append(d);
        return this;
    }

    public StringMaker replace(int start, int end, String str) {
        this.delegate.replace(start, end, str);
        return this;
    }

    public String substring(int start, int end) {
        return this.delegate.substring(start, end);
    }

    public StringMaker delete(int start, int end) {
        this.delegate.delete(start, end);
        return this;
    }

    public int length() {
        return this.delegate.length();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static StringMakerFactory getStringMakerFactory() {
        return factory;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringBuilderImpl other = (StringBuilderImpl)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    private static final class Factory
    implements StringMakerFactory {
        private Factory() {
        }

        public StringMaker newString() {
            return new StringBuilderImpl();
        }

        public StringMaker newString(int capacity) {
            return new StringBuilderImpl(capacity);
        }

        public StringMaker newString(String str) {
            return new StringBuilderImpl(str);
        }
    }
}

