/*
 * Decompiled with CFR 0.152.
 */
package fr.ms.util.logging;

import fr.ms.util.logging.Logger;
import fr.ms.util.logging.LoggerFactory;
import fr.ms.util.logging.impl.DefaultLogger;
import fr.ms.util.logging.impl.FilePrintHandler;
import fr.ms.util.logging.impl.PrintHandler;
import fr.ms.util.logging.impl.SystemOutPrintHandler;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DefaultLoggerFactory
implements LoggerFactory {
    private static final String PROPERTY_FILE = "log4jdbc.log.file";
    private static final String PREFIX = "log4jdbc.log.level.";
    private static final Map LOG_LEVEL = new HashMap();
    private PrintHandler printHandler = new SystemOutPrintHandler();

    public DefaultLoggerFactory() {
        this.initPrintHandler();
        this.initLevel();
    }

    private void initPrintHandler() {
        String property = System.getProperty(PROPERTY_FILE);
        if (property != null) {
            File file = new File(property);
            boolean fileExists = file.exists();
            if (!fileExists) {
                try {
                    file.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.printHandler = new FilePrintHandler(file);
        }
    }

    private void initLevel() {
        Properties properties = System.getProperties();
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            String propName = (String)en.nextElement();
            if (!propName.startsWith(PREFIX)) continue;
            String propValue = properties.getProperty(propName);
            propName = propName.substring(PREFIX.length());
            LOG_LEVEL.put(propName, propValue);
        }
    }

    private String getLevel(String name) {
        String nameLogger = null;
        String levelLogger = null;
        Iterator entries = LOG_LEVEL.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry element = entries.next();
            String key = (String)element.getKey();
            if (!name.startsWith(key) || nameLogger != null && key.length() <= nameLogger.length()) continue;
            nameLogger = key;
            levelLogger = (String)element.getValue();
        }
        if (levelLogger != null) {
            return levelLogger.toLowerCase();
        }
        return levelLogger;
    }

    public Logger getLogger(String name) {
        String level = this.getLevel(name);
        DefaultLogger logger = new DefaultLogger(this.printHandler, level, name);
        return logger;
    }
}

