/*
 * Decompiled with CFR 0.152.
 */
package fr.ms.util.logging.impl;

import fr.ms.lang.delegate.DefaultStringMakerFactory;
import fr.ms.lang.delegate.StringMakerFactory;
import fr.ms.lang.stringmaker.impl.StringMaker;
import fr.ms.util.logging.Logger;
import fr.ms.util.logging.impl.PrintHandler;
import fr.ms.util.logging.impl.WriterLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class DefaultLogger
implements Logger {
    private static final String nl = System.getProperty("line.separator");
    private static final StringMakerFactory stringMakerFactory = DefaultStringMakerFactory.getInstance();
    private final PrintHandler printHandler;
    private final String name;
    private String level;
    private boolean trace;
    private boolean debug;
    private boolean info;
    private boolean warn;
    private boolean error;
    private boolean fatal;

    public DefaultLogger(PrintHandler printHandler, String level, String name) {
        this.printHandler = printHandler;
        if (level != null) {
            if (level.equals("trace")) {
                this.trace = true;
                this.debug = true;
                this.info = true;
                this.error = true;
            } else if (level.equals("debug")) {
                this.debug = true;
                this.info = true;
                this.error = true;
            } else if (level.equals("info")) {
                this.info = true;
                this.error = true;
            } else if (level.equals("warn")) {
                this.warn = true;
                this.error = true;
            } else if (level.equals("error")) {
                this.error = true;
            } else if (level.equals("fatal")) {
                this.fatal = true;
            }
            this.level = level.toUpperCase();
        }
        this.name = name;
    }

    public boolean isTraceEnabled() {
        return this.trace;
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public boolean isInfoEnabled() {
        return this.info;
    }

    public boolean isWarnEnabled() {
        return this.warn;
    }

    public boolean isErrorEnabled() {
        return this.error;
    }

    public boolean isFatalEnabled() {
        return this.fatal;
    }

    public void trace(String message) {
        this.trace(message, null);
    }

    public void trace(String message, Throwable t) {
        if (this.isTraceEnabled()) {
            String formatMessage = this.formatMessage(message) + this.getException(t);
            this.printHandler.trace(formatMessage);
        }
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            String formatMessage = this.formatMessage(message) + this.getException(t);
            this.printHandler.debug(formatMessage);
        }
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            String formatMessage = this.formatMessage(message) + this.getException(t);
            this.printHandler.info(formatMessage);
        }
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable t) {
        if (this.isWarnEnabled()) {
            String formatMessage = this.formatMessage(message) + this.getException(t);
            this.printHandler.warn(formatMessage);
        }
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            String formatMessage = this.formatMessage(message) + this.getException(t);
            this.printHandler.error(formatMessage);
        }
    }

    public void fatal(String message) {
        this.fatal(message, null);
    }

    public void fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            String formatMessage = this.formatMessage(message) + this.getException(t);
            this.printHandler.fatal(formatMessage);
        }
    }

    private String getException(Throwable t) {
        String exception = "";
        if (t != null) {
            StringWriter errors = new StringWriter();
            t.printStackTrace(new PrintWriter(errors));
            exception = nl + t.getMessage() + nl + errors.toString();
        }
        return exception;
    }

    private String formatMessage(String message) {
        Date now = new Date();
        StringMaker newMessage = stringMakerFactory.newString();
        newMessage.append("[");
        newMessage.append(now);
        newMessage.append("]");
        newMessage.append(" [");
        newMessage.append(this.level);
        newMessage.append("]");
        newMessage.append(" [");
        newMessage.append(this.name);
        newMessage.append("] ");
        newMessage.append(message);
        return newMessage.toString();
    }

    public PrintWriter getPrintWriter() {
        WriterLogger writerLogger = new WriterLogger(this);
        return new PrintWriter(writerLogger);
    }

    public String toString() {
        return "DefaultLogger [name=" + this.name + ", level=" + this.level + "]";
    }
}

