/*
 * Decompiled with CFR 0.152.
 */
package com.github.maricn.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SlackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String API_URL = "https://slack.com/api/chat.postMessage";
    private static Layout<ILoggingEvent> defaultLayout = new LayoutBase<ILoggingEvent>(){

        public String doLayout(ILoggingEvent event) {
            return "-- [" + event.getLevel() + "]" + event.getLoggerName() + " - " + event.getFormattedMessage().replaceAll("\n", "\n\t");
        }
    };
    private String token;
    private String channel;
    private String username;
    private String iconEmoji;
    private Layout<ILoggingEvent> layout = defaultLayout;
    private int timeout = 30000;

    protected void append(ILoggingEvent evt) {
        try {
            URL url = new URL(API_URL);
            StringWriter requestParams = new StringWriter();
            requestParams.append("token=").append(this.token).append("&");
            String[] parts = this.layout.doLayout((Object)evt).split("\n", 2);
            requestParams.append("text=").append(URLEncoder.encode(parts[0], "UTF-8")).append('&');
            if (parts.length > 1) {
                HashMap<String, String> attachment = new HashMap<String, String>();
                attachment.put("text", parts[1]);
                List attachments = Collections.singletonList(attachment);
                String json = new ObjectMapper().writeValueAsString(attachments);
                requestParams.append("attachments=").append(URLEncoder.encode(json, "UTF-8")).append('&');
            }
            if (this.channel != null) {
                requestParams.append("channel=").append(URLEncoder.encode(this.channel, "UTF-8")).append('&');
            }
            if (this.username != null) {
                requestParams.append("username=").append(URLEncoder.encode(this.username, "UTF-8")).append('&');
            }
            if (this.iconEmoji != null) {
                requestParams.append("icon_emoji=").append(URLEncoder.encode(this.iconEmoji, "UTF-8"));
            }
            byte[] bytes = requestParams.toString().getBytes("UTF-8");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(this.timeout);
            conn.setReadTimeout(this.timeout);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setFixedLengthStreamingMode(bytes.length);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStream os = conn.getOutputStream();
            os.write(bytes);
            os.flush();
            os.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.addError("Error posting log to Slack.com (" + this.channel + "): " + evt, ex);
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getIconEmoji() {
        return this.iconEmoji;
    }

    public void setIconEmoji(String iconEmojiArg) {
        this.iconEmoji = iconEmojiArg;
        if (this.iconEmoji != null && !this.iconEmoji.isEmpty() && this.iconEmoji.startsWith(":") && !this.iconEmoji.endsWith(":")) {
            this.iconEmoji = this.iconEmoji + ":";
        }
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

