/*
 * Decompiled with CFR 0.152.
 */
package com.paginate.abslistview;

import android.database.DataSetObserver;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.BaseAdapter;
import android.widget.HeaderViewListAdapter;
import com.paginate.Paginate;
import com.paginate.abslistview.EndScrollListener;
import com.paginate.abslistview.LoadingListItemCreator;
import com.paginate.abslistview.WrapperAdapter;

public final class AbsListViewPaginate
extends Paginate
implements EndScrollListener.Callback {
    private final AbsListView absListView;
    private final Paginate.Callbacks callbacks;
    private EndScrollListener scrollListener;
    private WrapperAdapter wrapperAdapter;
    private final DataSetObserver dataSetObserver = new DataSetObserver(){

        public void onChanged() {
            AbsListViewPaginate.this.wrapperAdapter.displayLoadingRow(!AbsListViewPaginate.this.callbacks.hasLoadedAllItems());
            AbsListViewPaginate.this.wrapperAdapter.notifyDataSetChanged();
        }

        public void onInvalidated() {
            AbsListViewPaginate.this.wrapperAdapter.displayLoadingRow(!AbsListViewPaginate.this.callbacks.hasLoadedAllItems());
            AbsListViewPaginate.this.wrapperAdapter.notifyDataSetInvalidated();
        }
    };

    AbsListViewPaginate(AbsListView absListView, Paginate.Callbacks callbacks, int loadingTriggerThreshold, AbsListView.OnScrollListener onScrollListener, boolean addLoadingListItem, LoadingListItemCreator loadingListItemCreator) {
        this.absListView = absListView;
        this.callbacks = callbacks;
        this.scrollListener = new EndScrollListener(this);
        this.scrollListener.setThreshold(loadingTriggerThreshold);
        this.scrollListener.setDelegate(onScrollListener);
        absListView.setOnScrollListener((AbsListView.OnScrollListener)this.scrollListener);
        if (addLoadingListItem) {
            BaseAdapter adapter;
            if (absListView.getAdapter() instanceof BaseAdapter) {
                adapter = (BaseAdapter)absListView.getAdapter();
            } else if (absListView.getAdapter() instanceof HeaderViewListAdapter) {
                adapter = (BaseAdapter)((HeaderViewListAdapter)absListView.getAdapter()).getWrappedAdapter();
            } else {
                throw new IllegalStateException("Adapter needs to be subclass of BaseAdapter");
            }
            this.wrapperAdapter = new WrapperAdapter(adapter, loadingListItemCreator);
            adapter.registerDataSetObserver(this.dataSetObserver);
            absListView.setAdapter((Adapter)this.wrapperAdapter);
        }
    }

    @Override
    public void setHasMoreDataToLoad(boolean hasMoreDataToLoad) {
        if (this.wrapperAdapter != null) {
            this.wrapperAdapter.displayLoadingRow(hasMoreDataToLoad);
        }
    }

    @Override
    public void onEndReached() {
        if (!this.callbacks.isLoading() && !this.callbacks.hasLoadedAllItems()) {
            this.callbacks.onLoadMore();
        }
    }

    @Override
    public void unbind() {
        this.absListView.setOnScrollListener(this.scrollListener.getDelegateScrollListener());
        if (this.absListView.getAdapter() instanceof WrapperAdapter) {
            WrapperAdapter wrapperAdapter = (WrapperAdapter)this.absListView.getAdapter();
            BaseAdapter adapter = (BaseAdapter)wrapperAdapter.getWrappedAdapter();
            adapter.unregisterDataSetObserver(this.dataSetObserver);
            this.absListView.setAdapter((Adapter)adapter);
        }
    }

    public static class Builder {
        private final AbsListView absListView;
        private final Paginate.Callbacks callbacks;
        private int loadingTriggerThreshold = 5;
        private AbsListView.OnScrollListener onScrollListener;
        private boolean addLoadingListItem = true;
        private LoadingListItemCreator loadingListItemCreator;

        public Builder(AbsListView absListView, Paginate.Callbacks callbacks) {
            this.absListView = absListView;
            this.callbacks = callbacks;
        }

        public Builder setLoadingTriggerThreshold(int threshold) {
            this.loadingTriggerThreshold = threshold;
            return this;
        }

        public Builder setOnScrollListener(AbsListView.OnScrollListener onScrollListener) {
            this.onScrollListener = onScrollListener;
            return this;
        }

        public Builder addLoadingListItem(boolean addLoadingListItem) {
            this.addLoadingListItem = addLoadingListItem;
            return this;
        }

        public Builder setLoadingListItemCreator(LoadingListItemCreator loadingListItemCreator) {
            this.loadingListItemCreator = loadingListItemCreator;
            return this;
        }

        public Paginate build() {
            if (this.absListView.getAdapter() == null) {
                throw new IllegalStateException("Adapter needs to be set!");
            }
            if (this.loadingListItemCreator == null) {
                this.loadingListItemCreator = LoadingListItemCreator.DEFAULT;
            }
            return new AbsListViewPaginate(this.absListView, this.callbacks, this.loadingTriggerThreshold, this.onScrollListener, this.addLoadingListItem, this.loadingListItemCreator);
        }
    }
}

