/*
 * Decompiled with CFR 0.152.
 */
package com.paginate.recycler;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import com.paginate.Paginate;
import com.paginate.recycler.DefaultLoadingListItemSpanLookup;
import com.paginate.recycler.LoadingListItemCreator;
import com.paginate.recycler.LoadingListItemSpanLookup;
import com.paginate.recycler.WrapperAdapter;
import com.paginate.recycler.WrapperSpanSizeLookup;

public final class RecyclerPaginate
extends Paginate {
    private final RecyclerView recyclerView;
    private final Paginate.Callbacks callbacks;
    private final int loadingTriggerThreshold;
    private WrapperAdapter wrapperAdapter;
    private WrapperSpanSizeLookup wrapperSpanSizeLookup;
    private final RecyclerView.OnScrollListener mOnScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            RecyclerPaginate.this.checkEndOffset();
        }
    };
    private final RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            RecyclerPaginate.this.wrapperAdapter.notifyDataSetChanged();
            RecyclerPaginate.this.onAdapterDataChanged();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            RecyclerPaginate.this.wrapperAdapter.notifyItemRangeInserted(positionStart, itemCount);
            RecyclerPaginate.this.onAdapterDataChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            RecyclerPaginate.this.wrapperAdapter.notifyItemRangeChanged(positionStart, itemCount);
            RecyclerPaginate.this.onAdapterDataChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            RecyclerPaginate.this.wrapperAdapter.notifyItemRangeChanged(positionStart, itemCount, payload);
            RecyclerPaginate.this.onAdapterDataChanged();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            RecyclerPaginate.this.wrapperAdapter.notifyItemRangeRemoved(positionStart, itemCount);
            RecyclerPaginate.this.onAdapterDataChanged();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            RecyclerPaginate.this.wrapperAdapter.notifyItemMoved(fromPosition, toPosition);
            RecyclerPaginate.this.onAdapterDataChanged();
        }
    };

    RecyclerPaginate(RecyclerView recyclerView, Paginate.Callbacks callbacks, int loadingTriggerThreshold, boolean addLoadingListItem, LoadingListItemCreator loadingListItemCreator, LoadingListItemSpanLookup loadingListItemSpanLookup) {
        this.recyclerView = recyclerView;
        this.callbacks = callbacks;
        this.loadingTriggerThreshold = loadingTriggerThreshold;
        recyclerView.addOnScrollListener(this.mOnScrollListener);
        if (addLoadingListItem) {
            RecyclerView.Adapter adapter = recyclerView.getAdapter();
            this.wrapperAdapter = new WrapperAdapter(adapter, loadingListItemCreator);
            adapter.registerAdapterDataObserver(this.mDataObserver);
            recyclerView.setAdapter((RecyclerView.Adapter)this.wrapperAdapter);
            if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
                this.wrapperSpanSizeLookup = new WrapperSpanSizeLookup(((GridLayoutManager)recyclerView.getLayoutManager()).getSpanSizeLookup(), loadingListItemSpanLookup, this.wrapperAdapter);
                ((GridLayoutManager)recyclerView.getLayoutManager()).setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.wrapperSpanSizeLookup);
            }
        }
        this.checkEndOffset();
    }

    @Override
    public void setHasMoreDataToLoad(boolean hasMoreDataToLoad) {
        if (this.wrapperAdapter != null) {
            this.wrapperAdapter.displayLoadingRow(hasMoreDataToLoad);
        }
    }

    @Override
    public void unbind() {
        this.recyclerView.removeOnScrollListener(this.mOnScrollListener);
        if (this.recyclerView.getAdapter() instanceof WrapperAdapter) {
            WrapperAdapter wrapperAdapter = (WrapperAdapter)this.recyclerView.getAdapter();
            RecyclerView.Adapter adapter = wrapperAdapter.getWrappedAdapter();
            adapter.unregisterAdapterDataObserver(this.mDataObserver);
            this.recyclerView.setAdapter(adapter);
        }
        if (this.recyclerView.getLayoutManager() instanceof GridLayoutManager && this.wrapperSpanSizeLookup != null) {
            GridLayoutManager.SpanSizeLookup spanSizeLookup = this.wrapperSpanSizeLookup.getWrappedSpanSizeLookup();
            ((GridLayoutManager)this.recyclerView.getLayoutManager()).setSpanSizeLookup(spanSizeLookup);
        }
    }

    void checkEndOffset() {
        int firstVisibleItemPosition;
        int visibleItemCount = this.recyclerView.getChildCount();
        int totalItemCount = this.recyclerView.getLayoutManager().getItemCount();
        if (this.recyclerView.getLayoutManager() instanceof LinearLayoutManager) {
            firstVisibleItemPosition = ((LinearLayoutManager)this.recyclerView.getLayoutManager()).findFirstVisibleItemPosition();
        } else if (this.recyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager) {
            firstVisibleItemPosition = this.recyclerView.getLayoutManager().getChildCount() > 0 ? ((StaggeredGridLayoutManager)this.recyclerView.getLayoutManager()).findFirstVisibleItemPositions(null)[0] : 0;
        } else {
            throw new IllegalStateException("LayoutManager needs to subclass LinearLayoutManager or StaggeredGridLayoutManager");
        }
        if (!(totalItemCount - visibleItemCount > firstVisibleItemPosition + this.loadingTriggerThreshold && totalItemCount != 0 || this.callbacks.isLoading() || this.callbacks.hasLoadedAllItems())) {
            this.callbacks.onLoadMore();
        }
    }

    private void onAdapterDataChanged() {
        this.wrapperAdapter.displayLoadingRow(!this.callbacks.hasLoadedAllItems());
        this.checkEndOffset();
    }

    public static class Builder {
        private final RecyclerView recyclerView;
        private final Paginate.Callbacks callbacks;
        private int loadingTriggerThreshold = 5;
        private boolean addLoadingListItem = true;
        private LoadingListItemCreator loadingListItemCreator;
        private LoadingListItemSpanLookup loadingListItemSpanLookup;

        public Builder(RecyclerView recyclerView, Paginate.Callbacks callbacks) {
            this.recyclerView = recyclerView;
            this.callbacks = callbacks;
        }

        public Builder setLoadingTriggerThreshold(int threshold) {
            this.loadingTriggerThreshold = threshold;
            return this;
        }

        public Builder addLoadingListItem(boolean addLoadingListItem) {
            this.addLoadingListItem = addLoadingListItem;
            return this;
        }

        public Builder setLoadingListItemCreator(LoadingListItemCreator creator) {
            this.loadingListItemCreator = creator;
            return this;
        }

        public Builder setLoadingListItemSpanSizeLookup(LoadingListItemSpanLookup loadingListItemSpanLookup) {
            this.loadingListItemSpanLookup = loadingListItemSpanLookup;
            return this;
        }

        public Paginate build() {
            if (this.recyclerView.getAdapter() == null) {
                throw new IllegalStateException("Adapter needs to be set!");
            }
            if (this.recyclerView.getLayoutManager() == null) {
                throw new IllegalStateException("LayoutManager needs to be set on the RecyclerView");
            }
            if (this.loadingListItemCreator == null) {
                this.loadingListItemCreator = LoadingListItemCreator.DEFAULT;
            }
            if (this.loadingListItemSpanLookup == null) {
                this.loadingListItemSpanLookup = new DefaultLoadingListItemSpanLookup(this.recyclerView.getLayoutManager());
            }
            return new RecyclerPaginate(this.recyclerView, this.callbacks, this.loadingTriggerThreshold, this.addLoadingListItem, this.loadingListItemCreator, this.loadingListItemSpanLookup);
        }
    }
}

