/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.ui;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.util.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ProxyTester
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JComboBox<ProxySearch.Strategy> modes;
    private JButton testButton;
    private JTextField urlField;
    private JTextArea logArea;

    public ProxyTester() {
        this.init();
    }

    private void init() {
        this.setTitle("Proxy Vole Tester");
        this.setDefaultCloseOperation(3);
        JPanel p = new JPanel();
        p.add(new JLabel("Mode:"));
        this.modes = new JComboBox<ProxySearch.Strategy>(ProxySearch.Strategy.values());
        p.add(this.modes);
        p.add(new JLabel("URL:"));
        this.urlField = new JTextField(30);
        this.urlField.setText("http://www.google.com/");
        p.add(this.urlField);
        this.testButton = new JButton("Test");
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProxyTester.this.testUrl();
            }
        });
        p.add(this.testButton);
        this.logArea = new JTextArea(5, 50);
        JPanel contenPane = new JPanel(new BorderLayout());
        contenPane.add((Component)p, "North");
        contenPane.add((Component)new JScrollPane(this.logArea), "Center");
        this.setContentPane(contenPane);
        this.pack();
        this.setLocationRelativeTo(null);
        this.installLogger();
    }

    private void installLogger() {
        Logger.setBackend(new Logger.LogBackEnd(){

            @Override
            public void log(Class<?> clazz, Logger.LogLevel loglevel, String msg, Object ... params) {
                ProxyTester.this.logArea.append((Object)((Object)loglevel) + "\t" + MessageFormat.format(msg, params) + "\n");
            }

            @Override
            public boolean isLogginEnabled(Logger.LogLevel logLevel) {
                return true;
            }
        });
    }

    protected void testUrl() {
        try {
            if (this.urlField.getText().trim().length() == 0) {
                this.logArea.append("ERROR\tPlease enter an URL first.\n");
                return;
            }
            this.logArea.setText("");
            ProxySearch.Strategy pss = (ProxySearch.Strategy)((Object)this.modes.getSelectedItem());
            ProxySearch ps = new ProxySearch();
            ps.addStrategy(pss);
            ProxySelector psel = ps.getProxySelector();
            if (psel == null) {
                this.logArea.append("ERROR\tNo proxy settings available for this mode.\n");
                return;
            }
            ProxySelector.setDefault(psel);
            URL url = new URL(this.urlField.getText().trim());
            List<Proxy> result = psel.select(url.toURI());
            if (result == null || result.size() == 0) {
                this.logArea.append("INFO\tNo proxy found for this url.\n");
                return;
            }
            this.logArea.append("INFO\tProxy Settings found using " + (Object)((Object)pss) + " strategy.\n");
            this.logArea.append("INFO\tProxy used for URL is: " + result.get(0) + "\n");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error:" + e.getMessage(), "Error checking URL.", 0);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProxyTester.setLookAndFeel();
                ProxyTester mainFrame = new ProxyTester();
                mainFrame.setVisible(true);
            }
        });
    }

    private static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

