/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.portlet.server.request;

import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import org.springframework.mock.web.portlet.MockPortletRequest;
import org.springframework.mock.web.portlet.MockRenderRequest;
import org.springframework.test.web.portlet.server.PortletMvcResult;
import org.springframework.test.web.portlet.server.request.MockPortletRequestBuilder;
import org.springframework.test.web.portlet.server.request.RenderRequestBuilder;
import org.springframework.util.Assert;

public class MockRenderRequestBuilder
extends MockPortletRequestBuilder
implements RenderRequestBuilder {
    public MockRenderRequestBuilder param(String name, String ... values) {
        this.addParameter(name, values);
        return this;
    }

    public MockRenderRequestBuilder mode(PortletMode portletMode) {
        this.setPortletMode(portletMode);
        return this;
    }

    public MockRenderRequestBuilder windowState(WindowState windowState) {
        this.setWindowState(windowState);
        return this;
    }

    public MockRenderRequestBuilder copyRenderParameters(PortletMvcResult result) {
        Assert.isInstanceOf(ActionResponse.class, (Object)result.getResponse(), (String)"Only action requests results are supported");
        ActionResponse actionResponse = (ActionResponse)result.getResponse();
        Map renderParameterMap = actionResponse.getRenderParameterMap();
        for (String parameterName : renderParameterMap.keySet()) {
            this.addParameter(parameterName, (String[])renderParameterMap.get(parameterName));
        }
        return this;
    }

    public MockRenderRequestBuilder copySessionAttributes(PortletMvcResult result) {
        MockPortletRequest request = result.getRequest();
        PortletSession session = request.getPortletSession(false);
        if (session != null) {
            this.addSessionPortletAttributes(session.getAttributeMap(2));
            this.addSessionApplicationAttributes(session.getAttributeMap(1));
        }
        return this;
    }

    public MockRenderRequest buildRequest() {
        MockRenderRequest request = new MockRenderRequest();
        this.setAll((MockPortletRequest)request);
        return request;
    }
}

