/*
 * Decompiled with CFR 0.152.
 */
package com.github.marlonlom.utilities.timeago;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0002\u000b\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J'\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\t\"\u00020\u0001\u00a2\u0006\u0002\u0010\nR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/marlonlom/utilities/timeago/TimeAgoMessages;", "", "()V", "bundle", "Ljava/util/ResourceBundle;", "getPropertyValue", "", "property", "values", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "Builder", "Companion", "ta_library"})
public final class TimeAgoMessages {
    private ResourceBundle bundle;
    private static final String MESSAGES = "com.github.marlonlom.utilities.timeago.messages";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getPropertyValue(@NotNull String property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        ResourceBundle resourceBundle = this.bundle;
        if (resourceBundle == null) {
            Intrinsics.throwNpe();
        }
        String string = resourceBundle.getString(property);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bundle!!.getString(property)");
        return string;
    }

    @NotNull
    public final String getPropertyValue(@NotNull String property, Object ... values) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        String propertyVal = this.getPropertyValue(property);
        String string = MessageFormat.format(propertyVal, Arrays.copyOf(values, values.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MessageFormat.format(propertyVal, *values)");
        return string;
    }

    private TimeAgoMessages() {
    }

    static {
        MESSAGES = MESSAGES;
    }

    public /* synthetic */ TimeAgoMessages(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Nullable
    public static final /* synthetic */ ResourceBundle access$getBundle$p(TimeAgoMessages $this) {
        return $this.bundle;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/github/marlonlom/utilities/timeago/TimeAgoMessages$Builder;", "", "()V", "innerBundle", "Ljava/util/ResourceBundle;", "getInnerBundle", "()Ljava/util/ResourceBundle;", "setInnerBundle", "(Ljava/util/ResourceBundle;)V", "build", "Lcom/github/marlonlom/utilities/timeago/TimeAgoMessages;", "defaultLocale", "withLocale", "locale", "Ljava/util/Locale;", "ta_library"})
    public static final class Builder {
        @Nullable
        private ResourceBundle innerBundle;

        @Nullable
        public final ResourceBundle getInnerBundle() {
            return this.innerBundle;
        }

        public final void setInnerBundle(@Nullable ResourceBundle resourceBundle) {
            this.innerBundle = resourceBundle;
        }

        @NotNull
        public final TimeAgoMessages build() {
            TimeAgoMessages resources = new TimeAgoMessages(null);
            resources.bundle = this.innerBundle;
            return resources;
        }

        @NotNull
        public final Builder defaultLocale() {
            this.innerBundle = ResourceBundle.getBundle(MESSAGES);
            return this;
        }

        @NotNull
        public final Builder withLocale(@NotNull Locale locale) {
            Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
            this.innerBundle = ResourceBundle.getBundle(MESSAGES, locale);
            return this;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/marlonlom/utilities/timeago/TimeAgoMessages$Companion;", "", "()V", "MESSAGES", "", "ta_library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

