/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaConnectionConsumer;
import com.github.marschall.jakartajmsadapter.JakartaConnectionMetaData;
import com.github.marschall.jakartajmsadapter.JakartaSession;
import com.github.marschall.jakartajmsadapter.JavaxExceptionListener;
import com.github.marschall.jakartajmsadapter.Wrapper;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import javax.jms.Connection;
import javax.jms.Topic;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class JakartaConnection
implements jakarta.jms.Connection {
    private final Connection javaxConnection;
    private volatile ExceptionListener listener;

    JakartaConnection(Connection javaxConnection) {
        this.javaxConnection = javaxConnection;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        try {
            return new JakartaSession(this.javaxConnection.createSession(transacted, acknowledgeMode));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public Session createSession(int sessionMode) throws JMSException {
        try {
            return new JakartaSession(this.javaxConnection.createSession(sessionMode));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public Session createSession() throws JMSException {
        try {
            return new JakartaSession(this.javaxConnection.createSession());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public String getClientID() throws JMSException {
        try {
            return this.javaxConnection.getClientID();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void setClientID(String clientID) throws JMSException {
        try {
            this.javaxConnection.setClientID(clientID);
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        try {
            return new JakartaConnectionMetaData(this.javaxConnection.getMetaData());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        try {
            this.javaxConnection.getExceptionListener();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
        return this.listener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        JavaxExceptionListener javaxListener = listener != null ? new JavaxExceptionListener(listener) : null;
        try {
            this.javaxConnection.setExceptionListener((javax.jms.ExceptionListener)javaxListener);
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
        this.listener = listener;
    }

    public void start() throws JMSException {
        try {
            this.javaxConnection.start();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void stop() throws JMSException {
        try {
            this.javaxConnection.stop();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public void close() throws JMSException {
        try {
            this.javaxConnection.close();
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        javax.jms.Destination javaxDestination = Wrapper.unwrapObject(destination, javax.jms.Destination.class);
        javax.jms.ServerSessionPool javaxSessionPool = Wrapper.unwrapObject(sessionPool, javax.jms.ServerSessionPool.class);
        try {
            return new JakartaConnectionConsumer(this.javaxConnection.createConnectionConsumer(javaxDestination, messageSelector, javaxSessionPool, maxMessages));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public ConnectionConsumer createSharedConnectionConsumer(jakarta.jms.Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        javax.jms.ServerSessionPool javaxSessionPool = Wrapper.unwrapObject(sessionPool, javax.jms.ServerSessionPool.class);
        try {
            return new JakartaConnectionConsumer(this.javaxConnection.createSharedConnectionConsumer(javaxTopic, subscriptionName, messageSelector, javaxSessionPool, maxMessages));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public ConnectionConsumer createDurableConnectionConsumer(jakarta.jms.Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        javax.jms.ServerSessionPool javaxSessionPool = Wrapper.unwrapObject(sessionPool, javax.jms.ServerSessionPool.class);
        try {
            return new JakartaConnectionConsumer(this.javaxConnection.createDurableConnectionConsumer(javaxTopic, subscriptionName, messageSelector, javaxSessionPool, maxMessages));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(jakarta.jms.Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        Topic javaxTopic = Wrapper.unwrapObject(topic, Topic.class);
        javax.jms.ServerSessionPool javaxSessionPool = Wrapper.unwrapObject(sessionPool, javax.jms.ServerSessionPool.class);
        try {
            return new JakartaConnectionConsumer(this.javaxConnection.createSharedDurableConnectionConsumer(javaxTopic, subscriptionName, messageSelector, javaxSessionPool, maxMessages));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }
}

