/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSExceptionUtil;
import com.github.marschall.jakartajmsadapter.JMSRuntimeExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaConnection;
import com.github.marschall.jakartajmsadapter.JakartaJMSContext;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import java.util.Objects;
import javax.jms.JMSRuntimeException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class JakartaConnectionFactory
implements ConnectionFactory {
    private final javax.jms.ConnectionFactory javaxConnectionFactory;

    public JakartaConnectionFactory(javax.jms.ConnectionFactory javaxConnectionFactory) {
        Objects.requireNonNull(javaxConnectionFactory);
        this.javaxConnectionFactory = javaxConnectionFactory;
    }

    public Connection createConnection() throws JMSException {
        try {
            return new JakartaConnection(this.javaxConnectionFactory.createConnection());
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        try {
            return new JakartaConnection(this.javaxConnectionFactory.createConnection(userName, password));
        }
        catch (javax.jms.JMSException e) {
            throw JMSExceptionUtil.adaptException(e);
        }
    }

    public JMSContext createContext() {
        try {
            return new JakartaJMSContext(this.javaxConnectionFactory.createContext());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSContext createContext(String userName, String password) {
        try {
            return new JakartaJMSContext(this.javaxConnectionFactory.createContext(userName, password));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        try {
            return new JakartaJMSContext(this.javaxConnectionFactory.createContext(userName, password, sessionMode));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public JMSContext createContext(int sessionMode) {
        try {
            return new JakartaJMSContext(this.javaxConnectionFactory.createContext(sessionMode));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }
}

