/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.jakartajmsadapter;

import com.github.marschall.jakartajmsadapter.JMSRuntimeExceptionUtil;
import com.github.marschall.jakartajmsadapter.JakartaMessage;
import com.github.marschall.jakartajmsadapter.JavaxMessageListener;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import javax.jms.JMSConsumer;
import javax.jms.JMSRuntimeException;

final class JakartaJMSConsumer
implements jakarta.jms.JMSConsumer {
    private final JMSConsumer javaxConsumer;
    private MessageListener listener;

    JakartaJMSConsumer(JMSConsumer javaxConsumer) {
        this.javaxConsumer = javaxConsumer;
    }

    public String getMessageSelector() {
        try {
            return this.javaxConsumer.getMessageSelector();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public MessageListener getMessageListener() {
        try {
            this.javaxConsumer.getMessageListener();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) {
        JavaxMessageListener javaxListener = listener != null ? new JavaxMessageListener(listener) : null;
        try {
            this.javaxConsumer.setMessageListener((javax.jms.MessageListener)javaxListener);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
        this.listener = listener;
    }

    public Message receive() {
        try {
            return JakartaMessage.fromJavax(this.javaxConsumer.receive());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public Message receive(long timeout) {
        try {
            return JakartaMessage.fromJavax(this.javaxConsumer.receive(timeout));
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public Message receiveNoWait() {
        try {
            return JakartaMessage.fromJavax(this.javaxConsumer.receiveNoWait());
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public void close() {
        try {
            this.javaxConsumer.close();
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public <T> T receiveBody(Class<T> c) {
        try {
            return (T)this.javaxConsumer.receiveBody(c);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public <T> T receiveBody(Class<T> c, long timeout) {
        try {
            return (T)this.javaxConsumer.receiveBody(c, timeout);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }

    public <T> T receiveBodyNoWait(Class<T> c) {
        try {
            return (T)this.javaxConsumer.receiveBodyNoWait(c);
        }
        catch (JMSRuntimeException e) {
            throw JMSRuntimeExceptionUtil.adaptException(e);
        }
    }
}

